/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.serviceregistry;

import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.cloud.client.discovery.ManagementServerPortUtils;
import org.springframework.cloud.client.discovery.event.InstancePreRegisteredEvent;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.RegistrationLifecycle;
import org.springframework.cloud.client.serviceregistry.RegistrationManagementLifecycle;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;

public abstract class AbstractAutoServiceRegistration<R extends Registration>
implements AutoServiceRegistration,
ApplicationContextAware,
ApplicationListener<WebServerInitializedEvent> {
    private static final Log logger = LogFactory.getLog(AbstractAutoServiceRegistration.class);
    private final ServiceRegistry<R> serviceRegistry;
    private final boolean autoStartup = true;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final int order = 0;
    private final AtomicInteger port = new AtomicInteger(0);
    private ApplicationContext context;
    private Environment environment;
    private AutoServiceRegistrationProperties properties;
    private List<RegistrationManagementLifecycle<R>> registrationManagementLifecycles = new ArrayList<RegistrationManagementLifecycle<R>>();
    private List<RegistrationLifecycle<R>> registrationLifecycles = new ArrayList<RegistrationLifecycle<R>>();

    protected AbstractAutoServiceRegistration(ServiceRegistry<R> serviceRegistry, AutoServiceRegistrationProperties properties) {
        this.serviceRegistry = serviceRegistry;
        this.properties = properties;
    }

    protected AbstractAutoServiceRegistration(ServiceRegistry<R> serviceRegistry, AutoServiceRegistrationProperties properties, List<RegistrationManagementLifecycle<R>> registrationManagementLifecycles, List<RegistrationLifecycle<R>> registrationLifecycles) {
        this.serviceRegistry = serviceRegistry;
        this.properties = properties;
        this.registrationManagementLifecycles = registrationManagementLifecycles;
        this.registrationLifecycles = registrationLifecycles;
    }

    protected AbstractAutoServiceRegistration(ServiceRegistry<R> serviceRegistry, AutoServiceRegistrationProperties properties, List<RegistrationLifecycle<R>> registrationLifecycles) {
        this.serviceRegistry = serviceRegistry;
        this.properties = properties;
        this.registrationLifecycles = registrationLifecycles;
    }

    public void addRegistrationManagementLifecycle(RegistrationManagementLifecycle<R> registrationManagementLifecycle) {
        this.registrationManagementLifecycles.add(registrationManagementLifecycle);
    }

    public void addRegistrationLifecycle(RegistrationLifecycle<R> registrationLifecycle) {
        this.registrationLifecycles.add(registrationLifecycle);
    }

    protected ApplicationContext getContext() {
        return this.context;
    }

    @Override
    public void onApplicationEvent(WebServerInitializedEvent event) {
        WebServerApplicationContext context = event.getApplicationContext();
        if (context instanceof ConfigurableWebServerApplicationContext && "management".equals(((ConfigurableWebServerApplicationContext)context).getServerNamespace())) {
            return;
        }
        this.port.compareAndSet(0, event.getWebServer().getPort());
        this.start();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.environment = this.context.getEnvironment();
    }

    @Deprecated
    protected Environment getEnvironment() {
        return this.environment;
    }

    @Deprecated
    protected AtomicInteger getPort() {
        return this.port;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void start() {
        if (!this.isEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Discovery Lifecycle disabled. Not starting");
            }
            return;
        }
        if (!this.running.get()) {
            this.context.publishEvent(new InstancePreRegisteredEvent((Object)this, (Registration)this.getRegistration()));
            this.registrationLifecycles.forEach(registrationLifecycle -> registrationLifecycle.postProcessBeforeStartRegister(this.getRegistration()));
            this.register();
            this.registrationLifecycles.forEach(registrationLifecycle -> registrationLifecycle.postProcessAfterStartRegister(this.getRegistration()));
            if (this.shouldRegisterManagement()) {
                this.registrationManagementLifecycles.forEach(registrationManagementLifecycle -> registrationManagementLifecycle.postProcessBeforeStartRegisterManagement(this.getManagementRegistration()));
                this.registerManagement();
                this.registrationManagementLifecycles.forEach(registrationManagementLifecycle -> registrationManagementLifecycle.postProcessAfterStartRegisterManagement(this.getManagementRegistration()));
            }
            this.context.publishEvent(new InstanceRegisteredEvent<Object>((Object)this, this.getConfiguration()));
            this.running.compareAndSet(false, true);
        }
    }

    protected boolean shouldRegisterManagement() {
        if (this.properties == null || this.properties.isRegisterManagement()) {
            return this.getManagementPort() != null && ManagementServerPortUtils.isDifferent(this.context);
        }
        return false;
    }

    @Deprecated
    protected abstract Object getConfiguration();

    protected abstract boolean isEnabled();

    @Deprecated
    protected String getManagementServiceId() {
        return this.context.getId() + ":management";
    }

    @Deprecated
    protected String getManagementServiceName() {
        return this.getAppName() + ":management";
    }

    @Deprecated
    protected Integer getManagementPort() {
        return ManagementServerPortUtils.getPort(this.context);
    }

    @Deprecated
    protected String getAppName() {
        return this.environment.getProperty("spring.application.name", "application");
    }

    @PreDestroy
    public void destroy() {
        this.stop();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    protected AtomicBoolean getRunning() {
        return this.running;
    }

    public int getOrder() {
        return this.order;
    }

    public int getPhase() {
        return 0;
    }

    protected ServiceRegistry<R> getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected abstract R getRegistration();

    protected abstract R getManagementRegistration();

    protected void register() {
        this.serviceRegistry.register(this.getRegistration());
    }

    protected void registerManagement() {
        R registration = this.getManagementRegistration();
        if (registration != null) {
            this.serviceRegistry.register(registration);
        }
    }

    protected void deregister() {
        this.serviceRegistry.deregister(this.getRegistration());
    }

    protected void deregisterManagement() {
        R registration = this.getManagementRegistration();
        if (registration != null) {
            this.serviceRegistry.deregister(registration);
        }
    }

    public void stop() {
        if (this.getRunning().compareAndSet(true, false) && this.isEnabled()) {
            this.registrationLifecycles.forEach(registrationLifecycle -> registrationLifecycle.postProcessBeforeStopRegister(this.getRegistration()));
            this.deregister();
            this.registrationLifecycles.forEach(registrationLifecycle -> registrationLifecycle.postProcessAfterStopRegister(this.getRegistration()));
            if (this.shouldRegisterManagement()) {
                this.registrationManagementLifecycles.forEach(registrationManagementLifecycle -> registrationManagementLifecycle.postProcessBeforeStopRegisterManagement(this.getManagementRegistration()));
                this.deregisterManagement();
                this.registrationManagementLifecycles.forEach(registrationManagementLifecycle -> registrationManagementLifecycle.postProcessAfterStopRegisterManagement(this.getManagementRegistration()));
            }
            this.serviceRegistry.close();
        }
    }
}

