/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.cloud.bootstrap.config.BootstrapPropertySource;
import org.springframework.cloud.bootstrap.config.PropertySourceBootstrapProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.bootstrap.config.SimpleBootstrapPropertySource;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.logging.LoggingRebinder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={PropertySourceBootstrapProperties.class})
public class PropertySourceBootstrapConfiguration
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    public static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrapProperties";
    private static Log logger = LogFactory.getLog(PropertySourceBootstrapConfiguration.class);
    private int order = -2147483638;
    @Autowired(required=false)
    private List<PropertySourceLocator> propertySourceLocators = new ArrayList<PropertySourceLocator>();
    @Autowired
    private PropertySourceBootstrapProperties bootstrapProperties;

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setPropertySourceLocators(Collection<PropertySourceLocator> propertySourceLocators) {
        this.propertySourceLocators = new ArrayList<PropertySourceLocator>(propertySourceLocators);
    }

    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (!this.bootstrapProperties.isInitializeOnContextRefresh() || !applicationContext.getEnvironment().getPropertySources().contains("bootstrap")) {
            this.doInitialize(applicationContext);
        }
    }

    private void doInitialize(ConfigurableApplicationContext applicationContext) {
        ArrayList composite = new ArrayList();
        AnnotationAwareOrderComparator.sort(this.propertySourceLocators);
        boolean empty = true;
        ConfigurableEnvironment environment2 = applicationContext.getEnvironment();
        for (PropertySourceLocator locator : this.propertySourceLocators) {
            Collection<PropertySource<?>> source = locator.locateCollection(environment2);
            if (source == null || source.size() == 0) continue;
            ArrayList<PropertySource> sourceList = new ArrayList<PropertySource>();
            for (PropertySource<?> p : source) {
                if (p instanceof EnumerablePropertySource) {
                    EnumerablePropertySource enumerable = (EnumerablePropertySource)p;
                    sourceList.add(new BootstrapPropertySource(enumerable));
                    continue;
                }
                sourceList.add(new SimpleBootstrapPropertySource(p));
            }
            logger.info("Located property source: " + sourceList);
            composite.addAll(sourceList);
            empty = false;
        }
        if (!empty) {
            MutablePropertySources propertySources = environment2.getPropertySources();
            String logConfig = environment2.resolvePlaceholders("${logging.config:}");
            LogFile logFile = LogFile.get(environment2);
            for (PropertySource<?> p : environment2.getPropertySources()) {
                if (!p.getName().startsWith(BOOTSTRAP_PROPERTY_SOURCE_NAME)) continue;
                propertySources.remove(p.getName());
            }
            this.insertPropertySources(propertySources, composite);
            this.reinitializeLoggingSystem(environment2);
            this.setLogLevels(applicationContext, environment2);
            this.handleProfiles(environment2);
        }
    }

    private void reinitializeLoggingSystem(ConfigurableEnvironment environment2) {
        Map props = Binder.get(environment2).bind("logging", Bindable.mapOf(String.class, Object.class)).orElseGet(Collections::emptyMap);
        if (!props.isEmpty()) {
            String logConfig = environment2.resolvePlaceholders("${logging.config:}");
            LogFile logFile = LogFile.get(environment2);
            LoggingSystem system = LoggingSystem.get(LoggingSystem.class.getClassLoader());
            try {
                system.cleanUp();
                system.beforeInitialize();
                system.initialize(new LoggingInitializationContext(environment2), logConfig, logFile);
            }
            catch (Exception ex) {
                logger.warn("Error opening logging config file " + logConfig, ex);
            }
        }
    }

    private void setLogLevels(ConfigurableApplicationContext applicationContext, ConfigurableEnvironment environment2) {
        LoggingRebinder rebinder = new LoggingRebinder();
        rebinder.setEnvironment(environment2);
        rebinder.onApplicationEvent(new EnvironmentChangeEvent((Object)applicationContext, Collections.emptySet()));
    }

    private void insertPropertySources(MutablePropertySources propertySources, List<PropertySource<?>> composite) {
        MutablePropertySources incoming = new MutablePropertySources();
        ArrayList reversedComposite = new ArrayList(composite);
        Collections.reverse(reversedComposite);
        for (PropertySource propertySource : reversedComposite) {
            incoming.addFirst(propertySource);
        }
        PropertySourceBootstrapProperties remoteProperties = new PropertySourceBootstrapProperties();
        Binder.get(this.environment(incoming)).bind("spring.cloud.config", Bindable.ofInstance(remoteProperties));
        if (!remoteProperties.isAllowOverride() || !remoteProperties.isOverrideNone() && remoteProperties.isOverrideSystemProperties()) {
            for (PropertySource propertySource : reversedComposite) {
                if (propertySources.contains("decrypted")) {
                    propertySources.addAfter("decrypted", propertySource);
                    continue;
                }
                propertySources.addFirst(propertySource);
            }
            return;
        }
        if (remoteProperties.isOverrideNone()) {
            for (PropertySource<?> propertySource : composite) {
                propertySources.addLast(propertySource);
            }
            return;
        }
        if (propertySources.contains("systemEnvironment")) {
            if (!remoteProperties.isOverrideSystemProperties()) {
                for (PropertySource propertySource : reversedComposite) {
                    propertySources.addAfter("systemEnvironment", propertySource);
                }
            } else {
                for (PropertySource<?> propertySource : composite) {
                    propertySources.addBefore("systemEnvironment", propertySource);
                }
            }
        } else {
            for (PropertySource<?> propertySource : composite) {
                propertySources.addLast(propertySource);
            }
        }
    }

    private Environment environment(MutablePropertySources incoming) {
        AbstractEnvironment environment2 = new AbstractEnvironment(){};
        for (PropertySource<?> source : incoming) {
            environment2.getPropertySources().addLast(source);
        }
        return environment2;
    }

    private void handleProfiles(ConfigurableEnvironment environment2) {
        if (this.bootstrapProperties.isInitializeOnContextRefresh() && !environment2.getPropertySources().contains("bootstrap")) {
            return;
        }
        TreeSet<String> includeProfiles = new TreeSet<String>();
        ArrayList<String> activeProfiles = new ArrayList<String>();
        for (PropertySource<?> propertySource : environment2.getPropertySources()) {
            this.addIncludedProfilesTo(includeProfiles, propertySource, environment2);
            this.addActiveProfilesTo(activeProfiles, propertySource, environment2);
        }
        includeProfiles.removeAll(activeProfiles);
        for (String profile2 : includeProfiles) {
            activeProfiles.add(0, profile2);
        }
        List activeProfilesFromEnvironment = Arrays.stream(environment2.getActiveProfiles()).collect(Collectors.toList());
        if (!activeProfiles.containsAll(activeProfilesFromEnvironment)) {
            activeProfiles.addAll(activeProfilesFromEnvironment);
        }
        environment2.setActiveProfiles(activeProfiles.toArray(new String[activeProfiles.size()]));
    }

    private Set<String> addIncludedProfilesTo(Set<String> profiles, PropertySource<?> propertySource, ConfigurableEnvironment environment2) {
        return this.addProfilesTo(profiles, propertySource, "spring.profiles.include", environment2);
    }

    private List<String> addActiveProfilesTo(List<String> profiles, PropertySource<?> propertySource, ConfigurableEnvironment environment2) {
        if (!profiles.isEmpty()) {
            return profiles;
        }
        return this.addProfilesTo(profiles, propertySource, "spring.profiles.active", environment2);
    }

    private <T extends Collection<String>> T addProfilesTo(T profiles, PropertySource<?> propertySource, String property, ConfigurableEnvironment environment2) {
        if (propertySource instanceof CompositePropertySource) {
            for (PropertySource<?> nestedPropertySource : ((CompositePropertySource)propertySource).getPropertySources()) {
                this.addProfilesTo(profiles, nestedPropertySource, property, environment2);
            }
        } else {
            Collections.addAll(profiles, this.getProfilesForValue(propertySource.getProperty(property), environment2));
        }
        return profiles;
    }

    private String[] getProfilesForValue(Object property, ConfigurableEnvironment environment2) {
        String value = property == null ? null : property.toString();
        return property == null ? new String[]{} : this.resolvePlaceholdersInProfiles(value, environment2);
    }

    private String[] resolvePlaceholdersInProfiles(String profiles, ConfigurableEnvironment environment2) {
        return (String[])Arrays.stream(StringUtils.tokenizeToStringArray(profiles, ",")).map(s -> {
            if (s.startsWith("${") && s.endsWith("}")) {
                return environment2.resolvePlaceholders((String)s);
            }
            return s;
        }).toArray(String[]::new);
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.bootstrapProperties.isInitializeOnContextRefresh() && event.getApplicationContext() instanceof ConfigurableApplicationContext && ((ConfigurableApplicationContext)event.getApplicationContext()).getEnvironment().getPropertySources().contains("bootstrap")) {
            this.doInitialize((ConfigurableApplicationContext)event.getApplicationContext());
        }
    }
}

