/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.annotation;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.annotation.DiscoveredOperationMethod;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.invoke.OperationParameter;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.WebEndpointHttpMethod;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.WebOperationRequestPredicate;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

class RequestPredicateFactory {
    private final EndpointMediaTypes endpointMediaTypes;

    RequestPredicateFactory(EndpointMediaTypes endpointMediaTypes) {
        Assert.notNull((Object)endpointMediaTypes, "EndpointMediaTypes must not be null");
        this.endpointMediaTypes = endpointMediaTypes;
    }

    WebOperationRequestPredicate getRequestPredicate(String rootPath, DiscoveredOperationMethod operationMethod) {
        OperationParameter[] selectorParameters;
        Method method = operationMethod.getMethod();
        OperationParameter allRemainingPathSegmentsParameter = this.getAllRemainingPathSegmentsParameter(selectorParameters = (OperationParameter[])operationMethod.getParameters().stream().filter(this::hasSelector).toArray(OperationParameter[]::new));
        String path = this.getPath(rootPath, selectorParameters, allRemainingPathSegmentsParameter != null);
        WebEndpointHttpMethod httpMethod = this.determineHttpMethod(operationMethod.getOperationType());
        Collection<String> consumes = this.getConsumes(httpMethod, method);
        Collection<String> produces = this.getProduces(operationMethod, method);
        return new WebOperationRequestPredicate(path, httpMethod, consumes, produces);
    }

    private OperationParameter getAllRemainingPathSegmentsParameter(OperationParameter[] selectorParameters) {
        OperationParameter trailingPathsParameter = null;
        for (OperationParameter selectorParameter : selectorParameters) {
            Selector selector = selectorParameter.getAnnotation(Selector.class);
            if (selector.match() != Selector.Match.ALL_REMAINING) continue;
            Assert.state(trailingPathsParameter == null, "@Selector annotation with Match.ALL_REMAINING must be unique");
            trailingPathsParameter = selectorParameter;
        }
        if (trailingPathsParameter != null) {
            Assert.state(trailingPathsParameter == selectorParameters[selectorParameters.length - 1], "@Selector annotation with Match.ALL_REMAINING must be the last parameter");
        }
        return trailingPathsParameter;
    }

    private String getPath(String rootPath, OperationParameter[] selectorParameters, boolean matchRemainingPathSegments) {
        StringBuilder path = new StringBuilder(rootPath);
        for (int i2 = 0; i2 < selectorParameters.length; ++i2) {
            path.append(i2 != 0 || !rootPath.endsWith("/") ? "/{" : "{");
            if (i2 == selectorParameters.length - 1 && matchRemainingPathSegments) {
                path.append("*");
            }
            path.append(selectorParameters[i2].getName());
            path.append("}");
        }
        return path.toString();
    }

    private boolean hasSelector(OperationParameter parameter) {
        return parameter.getAnnotation(Selector.class) != null;
    }

    private Collection<String> getConsumes(WebEndpointHttpMethod httpMethod, Method method) {
        if (WebEndpointHttpMethod.POST == httpMethod && this.consumesRequestBody(method)) {
            return this.endpointMediaTypes.getConsumed();
        }
        return Collections.emptyList();
    }

    private Collection<String> getProduces(DiscoveredOperationMethod operationMethod, Method method) {
        if (!operationMethod.getProducesMediaTypes().isEmpty()) {
            return operationMethod.getProducesMediaTypes();
        }
        if (Void.class.equals(method.getReturnType()) || Void.TYPE.equals(method.getReturnType())) {
            return Collections.emptyList();
        }
        if (this.producesResource(method)) {
            return Collections.singletonList("application/octet-stream");
        }
        return this.endpointMediaTypes.getProduced();
    }

    private boolean producesResource(Method method) {
        if (Resource.class.equals(method.getReturnType())) {
            return true;
        }
        if (WebEndpointResponse.class.isAssignableFrom(method.getReturnType())) {
            ResolvableType returnType = ResolvableType.forMethodReturnType(method);
            return ResolvableType.forClass(Resource.class).isAssignableFrom(returnType.getGeneric(0));
        }
        return false;
    }

    private boolean consumesRequestBody(Method method) {
        return Stream.of(method.getParameters()).anyMatch(parameter -> parameter.getAnnotation(Selector.class) == null);
    }

    private WebEndpointHttpMethod determineHttpMethod(OperationType operationType) {
        if (operationType == OperationType.WRITE) {
            return WebEndpointHttpMethod.POST;
        }
        if (operationType == OperationType.DELETE) {
            return WebEndpointHttpMethod.DELETE;
        }
        return WebEndpointHttpMethod.GET;
    }
}

