/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.invoke.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import javax.annotation.Nonnull;
import javax.annotation.meta.When;
import org.springframework.boot.actuate.endpoint.invoke.OperationParameter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class OperationMethodParameter
implements OperationParameter {
    private static final boolean jsr305Present = ClassUtils.isPresent("javax.annotation.Nonnull", null);
    private final String name;
    private final Parameter parameter;

    OperationMethodParameter(String name, Parameter parameter) {
        this.name = name;
        this.parameter = parameter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.parameter.getType();
    }

    @Override
    public boolean isMandatory() {
        if (!ObjectUtils.isEmpty(this.parameter.getAnnotationsByType(Nullable.class))) {
            return false;
        }
        return jsr305Present ? new Jsr305().isMandatory(this.parameter) : true;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        return this.parameter.getAnnotation(annotation);
    }

    public String toString() {
        return this.name + " of type " + this.parameter.getType().getName();
    }

    private static final class Jsr305 {
        private Jsr305() {
        }

        boolean isMandatory(Parameter parameter) {
            MergedAnnotation<Nonnull> annotation = MergedAnnotations.from(parameter).get(Nonnull.class);
            return !annotation.isPresent() || annotation.getEnum("when", When.class) == When.ALWAYS;
        }
    }
}

