/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

class LogCorrelationEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    LogCorrelationEnvironmentPostProcessor() {
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment2, SpringApplication application) {
        if (ClassUtils.isPresent("io.micrometer.tracing.Tracer", application.getClassLoader())) {
            environment2.getPropertySources().addLast(new LogCorrelationPropertySource(this, environment2));
        }
    }

    private static class LogCorrelationPropertySource
    extends EnumerablePropertySource<Object> {
        private static final String NAME = "logCorrelation";
        private final Environment environment;

        LogCorrelationPropertySource(Object source, Environment environment2) {
            super(NAME, source);
            this.environment = environment2;
        }

        @Override
        public String[] getPropertyNames() {
            return new String[]{"logging.expect-correlation-id"};
        }

        @Override
        public Object getProperty(String name) {
            if (name.equals("logging.expect-correlation-id")) {
                return this.environment.getProperty("management.tracing.enabled", Boolean.class, Boolean.TRUE);
            }
            return null;
        }
    }
}

