/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.opentelemetry.OpenTelemetryProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration
@ConditionalOnClass(value={OpenTelemetrySdk.class})
@EnableConfigurationProperties(value={OpenTelemetryProperties.class})
public class OpenTelemetryAutoConfiguration {
    private static final String DEFAULT_APPLICATION_NAME = "application";
    private static final AttributeKey<String> ATTRIBUTE_KEY_SERVICE_NAME = AttributeKey.stringKey((String)"service.name");

    @Bean
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    OpenTelemetrySdk openTelemetry(ObjectProvider<SdkTracerProvider> tracerProvider, ObjectProvider<ContextPropagators> propagators, ObjectProvider<SdkLoggerProvider> loggerProvider, ObjectProvider<SdkMeterProvider> meterProvider) {
        OpenTelemetrySdkBuilder builder = OpenTelemetrySdk.builder();
        tracerProvider.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)builder).setTracerProvider(arg_0));
        propagators.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)builder).setPropagators(arg_0));
        loggerProvider.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)builder).setLoggerProvider(arg_0));
        meterProvider.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)builder).setMeterProvider(arg_0));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    Resource openTelemetryResource(Environment environment2, OpenTelemetryProperties properties) {
        String applicationName = environment2.getProperty("spring.application.name", DEFAULT_APPLICATION_NAME);
        return Resource.getDefault().merge(Resource.create((Attributes)Attributes.of(ATTRIBUTE_KEY_SERVICE_NAME, (Object)applicationName))).merge(OpenTelemetryAutoConfiguration.toResource(properties));
    }

    private static Resource toResource(OpenTelemetryProperties properties) {
        ResourceBuilder builder = Resource.builder();
        properties.getResourceAttributes().forEach((arg_0, arg_1) -> ((ResourceBuilder)builder).put(arg_0, arg_1));
        return builder.build();
    }
}

