/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.web.servlet;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.DispatcherType;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.OnlyOnceLoggingDenyMeterFilter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.ConditionalOnMissingFilterBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.observation.ServerRequestObservationConvention;
import org.springframework.web.filter.ServerHttpObservationFilter;
import org.springframework.web.servlet.DispatcherServlet;

@AutoConfiguration(after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, ObservationAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={DispatcherServlet.class, Observation.class})
@ConditionalOnBean(value={ObservationRegistry.class})
@EnableConfigurationProperties(value={MetricsProperties.class, ObservationProperties.class})
public class WebMvcObservationAutoConfiguration {
    @Bean
    @ConditionalOnMissingFilterBean
    public FilterRegistrationBean<ServerHttpObservationFilter> webMvcObservationFilter(ObservationRegistry registry, ObjectProvider<ServerRequestObservationConvention> customConvention, ObservationProperties observationProperties) {
        String name = observationProperties.getHttp().getServer().getRequests().getName();
        ServerRequestObservationConvention convention = customConvention.getIfAvailable(() -> new DefaultServerRequestObservationConvention(name));
        ServerHttpObservationFilter filter2 = new ServerHttpObservationFilter(registry, convention);
        FilterRegistrationBean<ServerHttpObservationFilter> registration = new FilterRegistrationBean<ServerHttpObservationFilter>(filter2, new ServletRegistrationBean[0]);
        registration.setOrder(-2147483647);
        registration.setDispatcherTypes(DispatcherType.REQUEST, DispatcherType.ASYNC);
        return registration;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class})
    @ConditionalOnBean(value={MeterRegistry.class})
    static class MeterFilterConfiguration {
        MeterFilterConfiguration() {
        }

        @Bean
        @Order(value=0)
        MeterFilter metricsHttpServerUriTagFilter(ObservationProperties observationProperties, MetricsProperties metricsProperties) {
            String name = observationProperties.getHttp().getServer().getRequests().getName();
            OnlyOnceLoggingDenyMeterFilter filter2 = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number of URI tags for '%s'.", name));
            return MeterFilter.maximumAllowableTags(name, "uri", metricsProperties.getWeb().getServer().getMaxUriTags(), filter2);
        }
    }
}

