/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.otlp;

import io.micrometer.registry.otlp.AggregationTemporality;
import io.micrometer.registry.otlp.OtlpConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpMetricsConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.properties.StepRegistryPropertiesConfigAdapter;
import org.springframework.boot.actuate.autoconfigure.opentelemetry.OpenTelemetryProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

class OtlpPropertiesConfigAdapter
extends StepRegistryPropertiesConfigAdapter<OtlpProperties>
implements OtlpConfig {
    private static final String DEFAULT_APPLICATION_NAME = "application";
    private final OpenTelemetryProperties openTelemetryProperties;
    private final OtlpMetricsConnectionDetails connectionDetails;
    private final Environment environment;

    OtlpPropertiesConfigAdapter(OtlpProperties properties, OpenTelemetryProperties openTelemetryProperties, OtlpMetricsConnectionDetails connectionDetails, Environment environment2) {
        super(properties);
        this.connectionDetails = connectionDetails;
        this.openTelemetryProperties = openTelemetryProperties;
        this.environment = environment2;
    }

    @Override
    public String prefix() {
        return "management.otlp.metrics.export";
    }

    public String url() {
        return this.get(properties -> this.connectionDetails.getUrl(), () -> super.url());
    }

    public AggregationTemporality aggregationTemporality() {
        return this.get(OtlpProperties::getAggregationTemporality, () -> super.aggregationTemporality());
    }

    public Map<String, String> resourceAttributes() {
        Map resourceAttributes = this.openTelemetryProperties.getResourceAttributes();
        HashMap<String, String> result = new HashMap<String, String>(!CollectionUtils.isEmpty(resourceAttributes) ? resourceAttributes : this.get(OtlpProperties::getResourceAttributes, () -> super.resourceAttributes()));
        result.computeIfAbsent("service.name", key -> this.getApplicationName());
        return Collections.unmodifiableMap(result);
    }

    private String getApplicationName() {
        return this.environment.getProperty("spring.application.name", DEFAULT_APPLICATION_NAME);
    }

    public Map<String, String> headers() {
        return this.get(OtlpProperties::getHeaders, () -> super.headers());
    }

    public TimeUnit baseTimeUnit() {
        return this.get(OtlpProperties::getBaseTimeUnit, () -> super.baseTimeUnit());
    }
}

