/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.ansi.AnsiPropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class ResourceBanner
implements Banner {
    private static final Log logger = LogFactory.getLog(ResourceBanner.class);
    private final Resource resource;

    public ResourceBanner(Resource resource2) {
        Assert.notNull((Object)resource2, "Resource must not be null");
        Assert.isTrue(resource2.exists(), "Resource must exist");
        this.resource = resource2;
    }

    @Override
    public void printBanner(Environment environment2, Class<?> sourceClass, PrintStream out) {
        try {
            String banner = StreamUtils.copyToString(this.resource.getInputStream(), environment2.getProperty("spring.banner.charset", Charset.class, StandardCharsets.UTF_8));
            for (PropertyResolver resolver : this.getPropertyResolvers(environment2, sourceClass)) {
                banner = resolver.resolvePlaceholders(banner);
            }
            out.println(banner);
        }
        catch (Exception ex) {
            logger.warn(LogMessage.format("Banner not printable: %s (%s: '%s')", (Object)this.resource, ex.getClass(), (Object)ex.getMessage()), ex);
        }
    }

    protected List<PropertyResolver> getPropertyResolvers(Environment environment2, Class<?> sourceClass) {
        MutablePropertySources sources = new MutablePropertySources();
        if (environment2 instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment2;
            configurableEnvironment.getPropertySources().forEach(sources::addLast);
        }
        sources.addLast(this.getTitleSource(sourceClass));
        sources.addLast(this.getAnsiSource());
        sources.addLast(this.getVersionSource(sourceClass));
        ArrayList<PropertyResolver> resolvers = new ArrayList<PropertyResolver>();
        resolvers.add(new PropertySourcesPropertyResolver(sources));
        return resolvers;
    }

    private MapPropertySource getTitleSource(Class<?> sourceClass) {
        String applicationTitle = this.getApplicationTitle(sourceClass);
        Map<String, Object> titleMap = Collections.singletonMap("application.title", applicationTitle != null ? applicationTitle : "");
        return new MapPropertySource("title", titleMap);
    }

    protected String getApplicationTitle(Class<?> sourceClass) {
        Package sourcePackage = sourceClass != null ? sourceClass.getPackage() : null;
        return sourcePackage != null ? sourcePackage.getImplementationTitle() : null;
    }

    private AnsiPropertySource getAnsiSource() {
        return new AnsiPropertySource("ansi", true);
    }

    private MapPropertySource getVersionSource(Class<?> sourceClass) {
        return new MapPropertySource("version", this.getVersionsMap(sourceClass));
    }

    private Map<String, Object> getVersionsMap(Class<?> sourceClass) {
        String appVersion = this.getApplicationVersion(sourceClass);
        String bootVersion = this.getBootVersion();
        HashMap<String, Object> versions = new HashMap<String, Object>();
        versions.put("application.version", this.getVersionString(appVersion, false));
        versions.put("spring-boot.version", this.getVersionString(bootVersion, false));
        versions.put("application.formatted-version", this.getVersionString(appVersion, true));
        versions.put("spring-boot.formatted-version", this.getVersionString(bootVersion, true));
        return versions;
    }

    protected String getApplicationVersion(Class<?> sourceClass) {
        Package sourcePackage = sourceClass != null ? sourceClass.getPackage() : null;
        return sourcePackage != null ? sourcePackage.getImplementationVersion() : null;
    }

    protected String getBootVersion() {
        return SpringBootVersion.getVersion();
    }

    private String getVersionString(String version, boolean format) {
        if (version == null) {
            return "";
        }
        return format ? " (v" + version + ")" : version;
    }
}

