/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.BivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math.analysis.interpolation.BivariateRealGridInterpolator;
import org.apache.commons.math.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.MathUtils;

@Deprecated
public class SmoothingBicubicSplineInterpolator
implements BivariateRealGridInterpolator {
    public BivariateRealFunction interpolate(double[] xval, double[] yval, double[][] zval) throws MathException, IllegalArgumentException {
        int i2;
        if (xval.length == 0 || yval.length == 0 || zval.length == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NO_DATA, new Object[0]);
        }
        if (xval.length != zval.length) {
            throw new DimensionMismatchException(xval.length, zval.length);
        }
        MathUtils.checkOrder(xval, MathUtils.OrderDirection.INCREASING, true);
        MathUtils.checkOrder(yval, MathUtils.OrderDirection.INCREASING, true);
        int xLen = xval.length;
        int yLen = yval.length;
        double[][] zX = new double[yLen][xLen];
        for (int i3 = 0; i3 < xLen; ++i3) {
            if (zval[i3].length != yLen) {
                throw new DimensionMismatchException(zval[i3].length, yLen);
            }
            for (int j = 0; j < yLen; ++j) {
                zX[j][i3] = zval[i3][j];
            }
        }
        SplineInterpolator spInterpolator = new SplineInterpolator();
        PolynomialSplineFunction[] ySplineX = new PolynomialSplineFunction[yLen];
        for (int j = 0; j < yLen; ++j) {
            ySplineX[j] = spInterpolator.interpolate(xval, zX[j]);
        }
        double[][] zY_1 = new double[xLen][yLen];
        for (int j = 0; j < yLen; ++j) {
            PolynomialSplineFunction f = ySplineX[j];
            for (i2 = 0; i2 < xLen; ++i2) {
                zY_1[i2][j] = f.value(xval[i2]);
            }
        }
        PolynomialSplineFunction[] xSplineY = new PolynomialSplineFunction[xLen];
        for (int i4 = 0; i4 < xLen; ++i4) {
            xSplineY[i4] = spInterpolator.interpolate(yval, zY_1[i4]);
        }
        double[][] zY_2 = new double[xLen][yLen];
        for (i2 = 0; i2 < xLen; ++i2) {
            PolynomialSplineFunction f = xSplineY[i2];
            for (int j = 0; j < yLen; ++j) {
                zY_2[i2][j] = f.value(yval[j]);
            }
        }
        double[][] dZdX = new double[xLen][yLen];
        for (int j = 0; j < yLen; ++j) {
            UnivariateRealFunction f = ySplineX[j].derivative();
            for (int i5 = 0; i5 < xLen; ++i5) {
                dZdX[i5][j] = f.value(xval[i5]);
            }
        }
        double[][] dZdY = new double[xLen][yLen];
        for (int i6 = 0; i6 < xLen; ++i6) {
            UnivariateRealFunction f = xSplineY[i6].derivative();
            for (int j = 0; j < yLen; ++j) {
                dZdY[i6][j] = f.value(yval[j]);
            }
        }
        double[][] dZdXdY = new double[xLen][yLen];
        for (int i7 = 0; i7 < xLen; ++i7) {
            int nI = this.nextIndex(i7, xLen);
            int pI = this.previousIndex(i7);
            for (int j = 0; j < yLen; ++j) {
                int nJ = this.nextIndex(j, yLen);
                int pJ = this.previousIndex(j);
                dZdXdY[i7][j] = (zY_2[nI][nJ] - zY_2[nI][pJ] - zY_2[pI][nJ] + zY_2[pI][pJ]) / ((xval[nI] - xval[pI]) * (yval[nJ] - yval[pJ]));
            }
        }
        return new BicubicSplineInterpolatingFunction(xval, yval, zY_2, dZdX, dZdY, dZdXdY);
    }

    private int nextIndex(int i2, int max) {
        int index = i2 + 1;
        return index < max ? index : index - 1;
    }

    private int previousIndex(int i2) {
        int index = i2 - 1;
        return index >= 0 ? index : 0;
    }
}

