/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class PropertiesConfiguration
extends AbstractFileConfiguration {
    static final String COMMENT_CHARS = "#!";
    static final String DEFAULT_SEPARATOR = " = ";
    private static final IOFactory DEFAULT_IO_FACTORY = new DefaultIOFactory();
    private static String include = "include";
    private static final char[] SEPARATORS = new char[]{'=', ':'};
    private static final char[] WHITE_SPACE = new char[]{' ', '\t', '\f'};
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String ESCAPE = "\\";
    private static final String DOUBLE_ESC = "\\\\";
    private static final int HEX_RADIX = 16;
    private static final int UNICODE_LEN = 4;
    private PropertiesConfigurationLayout layout;
    private volatile IOFactory ioFactory;
    private boolean includesAllowed = true;

    public PropertiesConfiguration() {
        this.layout = this.createLayout();
    }

    public PropertiesConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
    }

    public PropertiesConfiguration(File file) throws ConfigurationException {
        super(file);
        this.getLayout();
    }

    public PropertiesConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    public static String getInclude() {
        return include;
    }

    public static void setInclude(String inc) {
        include = inc;
    }

    public void setIncludesAllowed(boolean includesAllowed) {
        this.includesAllowed = includesAllowed;
    }

    @Deprecated
    public boolean getIncludesAllowed() {
        return this.isIncludesAllowed();
    }

    public boolean isIncludesAllowed() {
        return this.includesAllowed;
    }

    public String getHeader() {
        return this.getLayout().getHeaderComment();
    }

    public void setHeader(String header) {
        this.getLayout().setHeaderComment(header);
    }

    public String getFooter() {
        return this.getLayout().getFooterComment();
    }

    public void setFooter(String footer) {
        this.getLayout().setFooterComment(footer);
    }

    public String getEncoding() {
        String enc = super.getEncoding();
        return enc != null ? enc : DEFAULT_ENCODING;
    }

    public synchronized PropertiesConfigurationLayout getLayout() {
        if (this.layout == null) {
            this.layout = this.createLayout();
        }
        return this.layout;
    }

    public synchronized void setLayout(PropertiesConfigurationLayout layout) {
        if (this.layout != null) {
            this.removeConfigurationListener(this.layout);
        }
        this.layout = layout == null ? this.createLayout() : layout;
    }

    protected PropertiesConfigurationLayout createLayout() {
        return new PropertiesConfigurationLayout(this);
    }

    public IOFactory getIOFactory() {
        return this.ioFactory != null ? this.ioFactory : DEFAULT_IO_FACTORY;
    }

    public void setIOFactory(IOFactory ioFactory) {
        if (ioFactory == null) {
            throw new IllegalArgumentException("IOFactory must not be null!");
        }
        this.ioFactory = ioFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(Reader in) throws ConfigurationException {
        boolean oldAutoSave = this.isAutoSave();
        this.setAutoSave(false);
        try {
            this.getLayout().load(in);
        }
        finally {
            this.setAutoSave(oldAutoSave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Writer writer) throws ConfigurationException {
        this.enterNoReload();
        try {
            this.getLayout().save(writer);
        }
        finally {
            this.exitNoReload();
        }
    }

    public void setBasePath(String basePath) {
        super.setBasePath(basePath);
        this.setIncludesAllowed(StringUtils.isNotEmpty(basePath));
    }

    public Object clone() {
        PropertiesConfiguration copy = (PropertiesConfiguration)super.clone();
        if (this.layout != null) {
            copy.setLayout(new PropertiesConfigurationLayout(copy, this.layout));
        }
        return copy;
    }

    boolean propertyLoaded(String key, String value) throws ConfigurationException {
        boolean result;
        if (StringUtils.isNotEmpty(PropertiesConfiguration.getInclude()) && key.equalsIgnoreCase(PropertiesConfiguration.getInclude())) {
            if (this.isIncludesAllowed()) {
                String[] files = !this.isDelimiterParsingDisabled() ? StringUtils.split(value, this.getListDelimiter()) : new String[]{value};
                for (String f : files) {
                    this.loadIncludeFile(this.interpolate(f.trim()));
                }
            }
            result = false;
        } else {
            this.addProperty(key, value);
            result = true;
        }
        return result;
    }

    static boolean isCommentLine(String line) {
        String s = line.trim();
        return s.length() < 1 || COMMENT_CHARS.indexOf(s.charAt(0)) >= 0;
    }

    private static int countTrailingBS(String line) {
        int bsCount = 0;
        for (int idx = line.length() - 1; idx >= 0 && line.charAt(idx) == '\\'; --idx) {
            ++bsCount;
        }
        return bsCount;
    }

    protected static String unescapeJava(String str, char delimiter) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuilder out = new StringBuilder(sz);
        StringBuilder unicode = new StringBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i2 = 0; i2 < sz; ++i2) {
            char ch = str.charAt(i2);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new ConfigurationRuntimeException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                if (ch == '\\') {
                    out.append('\\');
                    continue;
                }
                if (ch == '\'') {
                    out.append('\'');
                    continue;
                }
                if (ch == '\"') {
                    out.append('\"');
                    continue;
                }
                if (ch == 'r') {
                    out.append('\r');
                    continue;
                }
                if (ch == 'f') {
                    out.append('\f');
                    continue;
                }
                if (ch == 't') {
                    out.append('\t');
                    continue;
                }
                if (ch == 'n') {
                    out.append('\n');
                    continue;
                }
                if (ch == 'b') {
                    out.append('\b');
                    continue;
                }
                if (ch == delimiter) {
                    out.append('\\');
                    out.append(delimiter);
                    continue;
                }
                if (ch == 'u') {
                    inUnicode = true;
                    continue;
                }
                out.append(ch);
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.append(ch);
        }
        if (hadSlash) {
            out.append('\\');
        }
        return out.toString();
    }

    private void loadIncludeFile(String fileName) throws ConfigurationException {
        URL baseURL;
        URL url = ConfigurationUtils.locate(this.getFileSystem(), this.getBasePath(), fileName);
        if (url == null && (baseURL = this.getURL()) != null) {
            url = ConfigurationUtils.locate(this.getFileSystem(), baseURL.toString(), fileName);
        }
        if (url == null) {
            throw new ConfigurationException("Cannot resolve include file " + fileName);
        }
        this.load(url);
    }

    public static class DefaultIOFactory
    implements IOFactory {
        public PropertiesReader createPropertiesReader(Reader in, char delimiter) {
            return new PropertiesReader(in, delimiter);
        }

        public PropertiesWriter createPropertiesWriter(Writer out, char delimiter) {
            return new PropertiesWriter(out, delimiter);
        }
    }

    public static interface IOFactory {
        public PropertiesReader createPropertiesReader(Reader var1, char var2);

        public PropertiesWriter createPropertiesWriter(Writer var1, char var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertiesWriter
    extends FilterWriter {
        private static final int BUF_SIZE = 8;
        private char delimiter;
        private String currentSeparator;
        private String globalSeparator;
        private String lineSeparator;

        public PropertiesWriter(Writer writer, char delimiter) {
            super(writer);
            this.delimiter = delimiter;
        }

        public String getCurrentSeparator() {
            return this.currentSeparator;
        }

        public void setCurrentSeparator(String currentSeparator) {
            this.currentSeparator = currentSeparator;
        }

        public String getGlobalSeparator() {
            return this.globalSeparator;
        }

        public void setGlobalSeparator(String globalSeparator) {
            this.globalSeparator = globalSeparator;
        }

        public String getLineSeparator() {
            return this.lineSeparator != null ? this.lineSeparator : LINE_SEPARATOR;
        }

        public void setLineSeparator(String lineSeparator) {
            this.lineSeparator = lineSeparator;
        }

        public void writeProperty(String key, Object value) throws IOException {
            this.writeProperty(key, value, false);
        }

        public void writeProperty(String key, List<?> values) throws IOException {
            for (int i2 = 0; i2 < values.size(); ++i2) {
                this.writeProperty(key, values.get(i2));
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void writeProperty(String key, Object value, boolean forceSingleLine) throws IOException {
            String v;
            if (value instanceof List) {
                List values = (List)value;
                if (!forceSingleLine) {
                    this.writeProperty(key, values);
                    return;
                }
                v = this.makeSingleLineValue(values);
            } else {
                v = this.escapeValue(value, false);
            }
            this.write(this.escapeKey(key));
            this.write(this.fetchSeparator(key, value));
            this.write(v);
            this.writeln(null);
        }

        public void writeComment(String comment) throws IOException {
            this.writeln("# " + comment);
        }

        private String escapeKey(String key) {
            StringBuilder newkey = new StringBuilder();
            for (int i2 = 0; i2 < key.length(); ++i2) {
                char c = key.charAt(i2);
                if (ArrayUtils.contains(SEPARATORS, c) || ArrayUtils.contains(WHITE_SPACE, c)) {
                    newkey.append('\\');
                    newkey.append(c);
                    continue;
                }
                newkey.append(c);
            }
            return newkey.toString();
        }

        private String escapeValue(Object value, boolean inList) {
            String escapedValue = this.handleBackslashs(value, inList);
            if (this.delimiter != '\u0000') {
                escapedValue = StringUtils.replace(escapedValue, String.valueOf(this.delimiter), PropertiesConfiguration.ESCAPE + this.delimiter);
            }
            return escapedValue;
        }

        private String handleBackslashs(Object value, boolean inList) {
            String strValue = String.valueOf(value);
            if (inList && strValue.indexOf(PropertiesConfiguration.DOUBLE_ESC) >= 0) {
                char esc = PropertiesConfiguration.ESCAPE.charAt(0);
                StringBuilder buf = new StringBuilder(strValue.length() + 8);
                for (int i2 = 0; i2 < strValue.length(); ++i2) {
                    if (strValue.charAt(i2) == esc && i2 < strValue.length() - 1 && strValue.charAt(i2 + 1) == esc) {
                        buf.append(PropertiesConfiguration.DOUBLE_ESC).append(PropertiesConfiguration.DOUBLE_ESC);
                        ++i2;
                        continue;
                    }
                    buf.append(strValue.charAt(i2));
                }
                strValue = buf.toString();
            }
            return StringEscapeUtils.escapeJava(strValue);
        }

        private String makeSingleLineValue(List<?> values) {
            if (!values.isEmpty()) {
                Iterator<?> it = values.iterator();
                String lastValue = this.escapeValue(it.next(), true);
                StringBuilder buf = new StringBuilder(lastValue);
                while (it.hasNext()) {
                    if (lastValue.endsWith(PropertiesConfiguration.ESCAPE) && PropertiesConfiguration.countTrailingBS(lastValue) / 2 % 2 != 0) {
                        buf.append(PropertiesConfiguration.ESCAPE).append(PropertiesConfiguration.ESCAPE);
                    }
                    buf.append(this.delimiter);
                    lastValue = this.escapeValue(it.next(), true);
                    buf.append(lastValue);
                }
                return buf.toString();
            }
            return null;
        }

        public void writeln(String s) throws IOException {
            if (s != null) {
                this.write(s);
            }
            this.write(this.getLineSeparator());
        }

        protected String fetchSeparator(String key, Object value) {
            return this.getGlobalSeparator() != null ? this.getGlobalSeparator() : this.getCurrentSeparator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertiesReader
    extends LineNumberReader {
        private static final Pattern PROPERTY_PATTERN = Pattern.compile("(([\\S&&[^\\\\" + new String(PropertiesConfiguration.access$000()) + "]]|\\\\.)*)(\\s*(\\s+|[" + new String(PropertiesConfiguration.access$000()) + "])\\s*)(.*)");
        private static final int IDX_KEY = 1;
        private static final int IDX_VALUE = 5;
        private static final int IDX_SEPARATOR = 3;
        private List<String> commentLines = new ArrayList<String>();
        private String propertyName;
        private String propertyValue;
        private String propertySeparator = " = ";
        private char delimiter;

        public PropertiesReader(Reader reader) {
            this(reader, AbstractConfiguration.getDefaultListDelimiter());
        }

        public PropertiesReader(Reader reader, char listDelimiter) {
            super(reader);
            this.delimiter = listDelimiter;
        }

        public String readProperty() throws IOException {
            String line;
            this.commentLines.clear();
            StringBuilder buffer = new StringBuilder();
            while (true) {
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (PropertiesConfiguration.isCommentLine(line)) {
                    this.commentLines.add(line);
                    continue;
                }
                if (!PropertiesReader.checkCombineLines(line = line.trim())) break;
                line = line.substring(0, line.length() - 1);
                buffer.append(line);
            }
            buffer.append(line);
            return buffer.toString();
        }

        public boolean nextProperty() throws IOException {
            String line = this.readProperty();
            if (line == null) {
                return false;
            }
            this.parseProperty(line);
            return true;
        }

        public List<String> getCommentLines() {
            return this.commentLines;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public String getPropertySeparator() {
            return this.propertySeparator;
        }

        protected void parseProperty(String line) {
            String[] property = PropertiesReader.doParseProperty(line);
            this.initPropertyName(property[0]);
            this.initPropertyValue(property[1]);
            this.initPropertySeparator(property[2]);
        }

        protected void initPropertyName(String name) {
            this.propertyName = StringEscapeUtils.unescapeJava(name);
        }

        protected void initPropertyValue(String value) {
            this.propertyValue = PropertiesConfiguration.unescapeJava(value, this.delimiter);
        }

        protected void initPropertySeparator(String value) {
            this.propertySeparator = value;
        }

        private static boolean checkCombineLines(String line) {
            return PropertiesConfiguration.countTrailingBS(line) % 2 != 0;
        }

        private static String[] doParseProperty(String line) {
            Matcher matcher = PROPERTY_PATTERN.matcher(line);
            String[] result = new String[]{"", "", ""};
            if (matcher.matches()) {
                result[0] = matcher.group(1).trim();
                result[1] = matcher.group(5).trim();
                result[2] = matcher.group(3);
            }
            return result;
        }
    }
}

