/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.StepCounter;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.util.ExpiringCache;
import com.netflix.servo.util.Preconditions;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicCounter
extends AbstractMonitor<Long>
implements CompositeMonitor<Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicCounter.class);
    private static final String DEFAULT_EXPIRATION = "15";
    private static final String DEFAULT_EXPIRATION_UNIT = "MINUTES";
    private static final String CLASS_NAME = DynamicCounter.class.getCanonicalName();
    private static final String EXPIRATION_PROP = CLASS_NAME + ".expiration";
    private static final String EXPIRATION_PROP_UNIT = CLASS_NAME + ".expirationUnit";
    private static final String INTERNAL_ID = "servoCounters";
    private static final MonitorConfig BASE_CONFIG = new MonitorConfig.Builder("servoCounters").build();
    private static final DynamicCounter INSTANCE = new DynamicCounter();
    private final ExpiringCache<MonitorConfig, Counter> counters;

    private DynamicCounter() {
        super(BASE_CONFIG);
        String expiration = System.getProperty(EXPIRATION_PROP, DEFAULT_EXPIRATION);
        String expirationUnit = System.getProperty(EXPIRATION_PROP_UNIT, DEFAULT_EXPIRATION_UNIT);
        long expirationValue = Long.parseLong(expiration);
        TimeUnit expirationUnitValue = TimeUnit.valueOf(expirationUnit);
        long expireAfterMs = expirationUnitValue.toMillis(expirationValue);
        this.counters = new ExpiringCache<MonitorConfig, Counter>(expireAfterMs, StepCounter::new);
        DefaultMonitorRegistry.getInstance().register(this);
    }

    private Counter get(MonitorConfig config) {
        return this.counters.get(config);
    }

    public static void increment(MonitorConfig config) {
        INSTANCE.get(config).increment();
    }

    public static void increment(String name, String ... tags) {
        MonitorConfig.Builder configBuilder = MonitorConfig.builder(name);
        Preconditions.checkArgument(tags.length % 2 == 0, "The sequence of (key, value) pairs must have even size: one key, one value");
        try {
            for (int i2 = 0; i2 < tags.length; i2 += 2) {
                configBuilder.withTag(tags[i2], tags[i2 + 1]);
            }
            DynamicCounter.increment(configBuilder.build());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Failed to get a counter to increment: {}", (Object)e.getMessage());
        }
    }

    public static void increment(MonitorConfig config, long delta) {
        INSTANCE.get(config).increment(delta);
    }

    public static void increment(String name, TagList list) {
        MonitorConfig config = new MonitorConfig.Builder(name).withTags(list).build();
        DynamicCounter.increment(config);
    }

    public static void increment(String name, TagList list, long delta) {
        MonitorConfig config = MonitorConfig.builder(name).withTags(list).build();
        DynamicCounter.increment(config, delta);
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        List<Monitor<?>> list = this.counters.values();
        return list;
    }

    @Override
    public Long getValue(int pollerIndex) {
        return this.counters.size();
    }

    public String toString() {
        return "DynamicCounter{baseConfig" + BASE_CONFIG + ", totalCounters=" + this.counters.size() + ", counters=" + this.counters + '}';
    }
}

