/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.provider;

import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.provider.Serializer;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/json", "application/xml"})
@Consumes(value={"*/*"})
public class DiscoveryJerseyProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryJerseyProvider.class);
    private final EncoderWrapper jsonEncoder;
    private final DecoderWrapper jsonDecoder;
    private final EncoderWrapper xmlEncoder;
    private final DecoderWrapper xmlDecoder;

    public DiscoveryJerseyProvider() {
        this(null, null);
    }

    public DiscoveryJerseyProvider(EncoderWrapper jsonEncoder, DecoderWrapper jsonDecoder) {
        this.jsonEncoder = jsonEncoder == null ? CodecWrappers.getEncoder(CodecWrappers.LegacyJacksonJson.class) : jsonEncoder;
        this.jsonDecoder = jsonDecoder == null ? CodecWrappers.getDecoder(CodecWrappers.LegacyJacksonJson.class) : jsonDecoder;
        LOGGER.info("Using JSON encoding codec {}", (Object)this.jsonEncoder.codecName());
        LOGGER.info("Using JSON decoding codec {}", (Object)this.jsonDecoder.codecName());
        if (jsonEncoder instanceof CodecWrappers.JacksonJsonMini) {
            throw new UnsupportedOperationException("Encoder: " + jsonEncoder.codecName() + "is not supported for the client");
        }
        this.xmlEncoder = CodecWrappers.getEncoder(CodecWrappers.XStreamXml.class);
        this.xmlDecoder = CodecWrappers.getDecoder(CodecWrappers.XStreamXml.class);
        LOGGER.info("Using XML encoding codec {}", (Object)this.xmlEncoder.codecName());
        LOGGER.info("Using XML decoding codec {}", (Object)this.xmlDecoder.codecName());
    }

    @Override
    public boolean isReadable(Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return this.isSupportedMediaType(mediaType) && DiscoveryJerseyProvider.isSupportedCharset(mediaType) && DiscoveryJerseyProvider.isSupportedEntity(serializableClass);
    }

    @Override
    public Object readFrom(Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap headers, InputStream inputStream) throws IOException {
        DecoderWrapper decoder = "*".equals(mediaType.getSubtype()) ? this.xmlDecoder : ("json".equalsIgnoreCase(mediaType.getSubtype()) ? this.jsonDecoder : this.xmlDecoder);
        try {
            return decoder.decode(inputStream, serializableClass);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                DiscoveryJerseyProvider.closeInputOnError(inputStream);
                throw new WebApplicationException(e, DiscoveryJerseyProvider.createErrorReply(500, e, mediaType));
            }
            LOGGER.debug("Cannot parse request body", e);
            throw new WebApplicationException(e, DiscoveryJerseyProvider.createErrorReply(400, "cannot parse request body", mediaType));
        }
    }

    @Override
    public long getSize(Object serializableObject, Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return this.isSupportedMediaType(mediaType) && DiscoveryJerseyProvider.isSupportedEntity(serializableClass);
    }

    @Override
    public void writeTo(Object serializableObject, Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap headers, OutputStream outputStream) throws IOException, WebApplicationException {
        EncoderWrapper encoder;
        EncoderWrapper encoderWrapper = encoder = "json".equalsIgnoreCase(mediaType.getSubtype()) ? this.jsonEncoder : this.xmlEncoder;
        if (encoder == null) {
            throw new WebApplicationException(DiscoveryJerseyProvider.createErrorReply(400, "No codec available to serialize content type " + mediaType, mediaType));
        }
        encoder.encode(serializableObject, outputStream);
    }

    private boolean isSupportedMediaType(MediaType mediaType) {
        if (MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
            return true;
        }
        if (MediaType.APPLICATION_XML_TYPE.isCompatible(mediaType)) {
            return this.xmlDecoder != null;
        }
        return false;
    }

    private static boolean isSupportedCharset(MediaType mediaType) {
        Map<String, String> parameters = mediaType.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return true;
        }
        String charset = parameters.get("charset");
        return charset == null || "UTF-8".equalsIgnoreCase(charset) || "ISO-8859-1".equalsIgnoreCase(charset);
    }

    private static boolean isSupportedEntity(Class<?> entityType) {
        try {
            Serializer annotation = entityType.getAnnotation(Serializer.class);
            if (annotation != null) {
                return true;
            }
        }
        catch (Throwable th) {
            LOGGER.warn("Exception in checking for annotations", th);
        }
        return false;
    }

    private static Response createErrorReply(int status, Throwable cause, MediaType mediaType) {
        StringBuilder sb = new StringBuilder(cause.getClass().getName());
        if (cause.getMessage() != null) {
            sb.append(": ").append(cause.getMessage());
        }
        return DiscoveryJerseyProvider.createErrorReply(status, sb.toString(), mediaType);
    }

    private static Response createErrorReply(int status, String errorMessage, MediaType mediaType) {
        String message = MediaType.APPLICATION_JSON_TYPE.equals(mediaType) ? "{\"error\": \"" + errorMessage + "\"}" : "<error><message>" + errorMessage + "</message></error>";
        return Response.status(status).entity(message).type(mediaType).build();
    }

    private static void closeInputOnError(InputStream inputStream) {
        if (inputStream != null) {
            LOGGER.error("Unexpected error occurred during de-serialization of discovery data, done connection cleanup");
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.debug("Cannot close input", e);
            }
        }
    }
}

