/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.docs.MeterDocumentation;

enum HttpServerMeters implements MeterDocumentation
{
    CONNECTIONS_ACTIVE{

        @Override
        public String getName() {
            return "reactor.netty.http.server.connections.active";
        }

        @Override
        public KeyName[] getKeyNames() {
            return ConnectionsActiveTags.values();
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }
    }
    ,
    STREAMS_ACTIVE{

        @Override
        public String getName() {
            return "reactor.netty.http.server.streams.active";
        }

        @Override
        public KeyName[] getKeyNames() {
            return StreamsActiveTags.values();
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }
    }
    ,
    HTTP_SERVER_DATA_RECEIVED{

        @Override
        public String getBaseUnit() {
            return "bytes";
        }

        @Override
        public String getName() {
            return "%s";
        }

        @Override
        public KeyName[] getKeyNames() {
            return HttpServerMetersTags.values();
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.DISTRIBUTION_SUMMARY;
        }
    }
    ,
    HTTP_SERVER_DATA_RECEIVED_TIME{

        @Override
        public String getName() {
            return "reactor.netty.http.server.data.received.time";
        }

        @Override
        public KeyName[] getKeyNames() {
            return DataReceivedTimeTags.values();
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }
    }
    ,
    HTTP_SERVER_DATA_SENT{

        @Override
        public String getBaseUnit() {
            return "bytes";
        }

        @Override
        public String getName() {
            return "%s";
        }

        @Override
        public KeyName[] getKeyNames() {
            return HttpServerMetersTags.values();
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.DISTRIBUTION_SUMMARY;
        }
    }
    ,
    HTTP_SERVER_DATA_SENT_TIME{

        @Override
        public String getName() {
            return "reactor.netty.http.server.data.sent.time";
        }

        @Override
        public KeyName[] getKeyNames() {
            return DataSentTimeTags.values();
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }
    }
    ,
    HTTP_SERVER_ERRORS_COUNT{

        @Override
        public String getName() {
            return "%s";
        }

        @Override
        public KeyName[] getKeyNames() {
            return HttpServerMetersTags.values();
        }

        @Override
        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }
    };


    public static enum HttpServerMetersTags implements KeyName
    {
        URI{

            @Override
            public String asString() {
                return "uri";
            }
        };

    }

    static enum DataSentTimeTags implements KeyName
    {
        METHOD{

            @Override
            public String asString() {
                return "method";
            }
        }
        ,
        STATUS{

            @Override
            public String asString() {
                return "status";
            }
        }
        ,
        URI{

            @Override
            public String asString() {
                return "uri";
            }
        };

    }

    static enum DataReceivedTimeTags implements KeyName
    {
        METHOD{

            @Override
            public String asString() {
                return "method";
            }
        }
        ,
        URI{

            @Override
            public String asString() {
                return "uri";
            }
        };

    }

    static enum ConnectionsActiveTags implements KeyName
    {
        LOCAL_ADDRESS{

            @Override
            public String asString() {
                return "local.address";
            }
        }
        ,
        URI{

            @Override
            public String asString() {
                return "uri";
            }
        };

    }

    static enum StreamsActiveTags implements KeyName
    {
        LOCAL_ADDRESS{

            @Override
            public String asString() {
                return "local.address";
            }
        }
        ,
        URI{

            @Override
            public String asString() {
                return "uri";
            }
        };

    }
}

