/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public final class PatternsRequestCondition
extends AbstractRequestCondition<PatternsRequestCondition> {
    private static final SortedSet<PathPattern> EMPTY_PATH_PATTERN = new TreeSet<PathPattern>(Collections.singleton(PathPatternParser.defaultInstance.parse("")));
    private static final Set<String> EMPTY_PATH = Collections.singleton("");
    private static final SortedSet<PathPattern> ROOT_PATH_PATTERNS = new TreeSet<PathPattern>(List.of(new PathPatternParser().parse(""), new PathPatternParser().parse("/")));
    private final SortedSet<PathPattern> patterns;

    public PatternsRequestCondition(PathPattern ... patterns) {
        this(ObjectUtils.isEmpty(patterns) ? Collections.emptyList() : Arrays.asList(patterns));
    }

    public PatternsRequestCondition(List<PathPattern> patterns) {
        this.patterns = patterns.isEmpty() ? EMPTY_PATH_PATTERN : new TreeSet<PathPattern>(patterns);
    }

    private PatternsRequestCondition(SortedSet<PathPattern> patterns) {
        this.patterns = patterns;
    }

    public Set<PathPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    protected Collection<PathPattern> getContent() {
        return this.patterns;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    public boolean isEmptyPathMapping() {
        return this.patterns == EMPTY_PATH_PATTERN;
    }

    public Set<String> getDirectPaths() {
        if (this.isEmptyPathMapping()) {
            return EMPTY_PATH;
        }
        HashSet<String> result = Collections.emptySet();
        for (PathPattern pattern : this.patterns) {
            if (pattern.hasPatternSyntax()) continue;
            result = result.isEmpty() ? new HashSet<String>(1) : result;
            result.add(pattern.getPatternString());
        }
        return result;
    }

    @Override
    public PatternsRequestCondition combine(PatternsRequestCondition other) {
        if (this.isEmptyPathMapping() && other.isEmptyPathMapping()) {
            return new PatternsRequestCondition(ROOT_PATH_PATTERNS);
        }
        if (other.isEmptyPathMapping()) {
            return this;
        }
        if (this.isEmptyPathMapping()) {
            return other;
        }
        TreeSet<PathPattern> combined = new TreeSet<PathPattern>();
        for (PathPattern pattern1 : this.patterns) {
            for (PathPattern pattern2 : other.patterns) {
                combined.add(pattern1.combine(pattern2));
            }
        }
        return new PatternsRequestCondition(combined);
    }

    @Override
    @Nullable
    public PatternsRequestCondition getMatchingCondition(ServerWebExchange exchange2) {
        SortedSet<PathPattern> matches = this.getMatchingPatterns(exchange2);
        return matches != null ? new PatternsRequestCondition(matches) : null;
    }

    @Nullable
    private SortedSet<PathPattern> getMatchingPatterns(ServerWebExchange exchange2) {
        PathContainer lookupPath = exchange2.getRequest().getPath().pathWithinApplication();
        TreeSet<PathPattern> result = null;
        for (PathPattern pattern : this.patterns) {
            if (!pattern.matches(lookupPath)) continue;
            result = result != null ? result : new TreeSet<PathPattern>();
            result.add(pattern);
        }
        return result;
    }

    @Override
    public int compareTo(PatternsRequestCondition other, ServerWebExchange exchange2) {
        Iterator iterator = this.patterns.iterator();
        Iterator<PathPattern> iteratorOther = other.getPatterns().iterator();
        while (iterator.hasNext() && iteratorOther.hasNext()) {
            int result = PathPattern.SPECIFICITY_COMPARATOR.compare((PathPattern)iterator.next(), iteratorOther.next());
            if (result == 0) continue;
            return result;
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (iteratorOther.hasNext()) {
            return 1;
        }
        return 0;
    }
}

