/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.codec.Hints;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import reactor.core.publisher.Mono;

final class DefaultClientRequestBuilder
implements ClientRequest.Builder {
    private HttpMethod method;
    private URI url;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, String> cookies = new LinkedMultiValueMap<String, String>();
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private BodyInserter<?, ? super ClientHttpRequest> body = BodyInserters.empty();
    @Nullable
    private Consumer<ClientHttpRequest> httpRequestConsumer;

    public DefaultClientRequestBuilder(ClientRequest other) {
        Assert.notNull((Object)other, "ClientRequest must not be null");
        this.method = other.method();
        this.url = other.url();
        this.headers(headers -> headers.addAll(other.headers()));
        this.cookies(cookies -> cookies.addAll(other.cookies()));
        this.attributes(attributes -> attributes.putAll(other.attributes()));
        this.body(other.body());
        this.httpRequestConsumer = other.httpRequest();
    }

    public DefaultClientRequestBuilder(HttpMethod method, URI url) {
        Assert.notNull((Object)method, "HttpMethod must not be null");
        Assert.notNull((Object)url, "URI must not be null");
        this.method = method;
        this.url = url;
    }

    @Override
    public ClientRequest.Builder method(HttpMethod method) {
        Assert.notNull((Object)method, "HttpMethod must not be null");
        this.method = method;
        return this;
    }

    @Override
    public ClientRequest.Builder url(URI url) {
        Assert.notNull((Object)url, "URI must not be null");
        this.url = url;
        return this;
    }

    @Override
    public ClientRequest.Builder header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public ClientRequest.Builder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public ClientRequest.Builder cookie(String name, String ... values) {
        for (String value : values) {
            this.cookies.add(name, value);
        }
        return this;
    }

    @Override
    public ClientRequest.Builder cookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    @Override
    public <S, P extends Publisher<S>> ClientRequest.Builder body(P publisher, Class<S> elementClass) {
        this.body = BodyInserters.fromPublisher(publisher, elementClass);
        return this;
    }

    @Override
    public <S, P extends Publisher<S>> ClientRequest.Builder body(P publisher, ParameterizedTypeReference<S> typeReference) {
        this.body = BodyInserters.fromPublisher(publisher, typeReference);
        return this;
    }

    @Override
    public ClientRequest.Builder attribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public ClientRequest.Builder attributes(Consumer<Map<String, Object>> attributesConsumer) {
        attributesConsumer.accept(this.attributes);
        return this;
    }

    @Override
    public ClientRequest.Builder httpRequest(Consumer<ClientHttpRequest> requestConsumer) {
        this.httpRequestConsumer = this.httpRequestConsumer != null ? this.httpRequestConsumer.andThen(requestConsumer) : requestConsumer;
        return this;
    }

    @Override
    public ClientRequest.Builder body(BodyInserter<?, ? super ClientHttpRequest> inserter) {
        this.body = inserter;
        return this;
    }

    @Override
    public ClientRequest build() {
        return new BodyInserterRequest(this.method, this.url, this.headers, this.cookies, this.body, this.attributes, this.httpRequestConsumer);
    }

    private static class BodyInserterRequest
    implements ClientRequest {
        private final HttpMethod method;
        private final URI url;
        private final HttpHeaders headers;
        private final MultiValueMap<String, String> cookies;
        private final BodyInserter<?, ? super ClientHttpRequest> body;
        private final Map<String, Object> attributes;
        @Nullable
        private final Consumer<ClientHttpRequest> httpRequestConsumer;
        private final String logPrefix;

        public BodyInserterRequest(HttpMethod method, URI url, HttpHeaders headers, MultiValueMap<String, String> cookies, BodyInserter<?, ? super ClientHttpRequest> body2, Map<String, Object> attributes, @Nullable Consumer<ClientHttpRequest> httpRequestConsumer) {
            this.method = method;
            this.url = url;
            this.headers = HttpHeaders.readOnlyHttpHeaders(headers);
            this.cookies = CollectionUtils.unmodifiableMultiValueMap(cookies);
            this.body = body2;
            this.attributes = Collections.unmodifiableMap(attributes);
            this.httpRequestConsumer = httpRequestConsumer;
            Object id = attributes.computeIfAbsent(LOG_ID_ATTRIBUTE, name -> ObjectUtils.getIdentityHexString(this));
            this.logPrefix = "[" + id + "] ";
        }

        @Override
        public HttpMethod method() {
            return this.method;
        }

        @Override
        public URI url() {
            return this.url;
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public MultiValueMap<String, String> cookies() {
            return this.cookies;
        }

        @Override
        public BodyInserter<?, ? super ClientHttpRequest> body() {
            return this.body;
        }

        @Override
        public Map<String, Object> attributes() {
            return this.attributes;
        }

        @Override
        @Nullable
        public Consumer<ClientHttpRequest> httpRequest() {
            return this.httpRequestConsumer;
        }

        @Override
        public String logPrefix() {
            return this.logPrefix;
        }

        @Override
        public Mono<Void> writeTo(ClientHttpRequest request, final ExchangeStrategies strategies) {
            HttpHeaders requestHeaders = request.getHeaders();
            if (!this.headers.isEmpty()) {
                this.headers.forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)requestHeaders::putIfAbsent));
            }
            MultiValueMap<String, HttpCookie> requestCookies = request.getCookies();
            if (!this.cookies.isEmpty()) {
                this.cookies.forEach((name, values) -> values.forEach(value -> {
                    HttpCookie cookie = new HttpCookie((String)name, (String)value);
                    requestCookies.add((String)name, cookie);
                }));
            }
            if (this.httpRequestConsumer != null) {
                this.httpRequestConsumer.accept(request);
            }
            return this.body.insert(request, new BodyInserter.Context(){

                @Override
                public List<HttpMessageWriter<?>> messageWriters() {
                    return strategies.messageWriters();
                }

                @Override
                public Optional<ServerHttpRequest> serverRequest() {
                    return Optional.empty();
                }

                @Override
                public Map<String, Object> hints() {
                    return Hints.from(Hints.LOG_PREFIX_HINT, this.logPrefix());
                }
            });
        }
    }
}

