/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import jakarta.validation.ClockProvider;
import jakarta.validation.Configuration;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.ValidationProviderResolver;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.beanvalidation.LocaleContextMessageInterpolator;
import org.springframework.validation.beanvalidation.MessageSourceResourceBundleLocator;
import org.springframework.validation.beanvalidation.SpringConstraintValidatorFactory;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

public class LocalValidatorFactoryBean
extends SpringValidatorAdapter
implements ValidatorFactory,
ApplicationContextAware,
InitializingBean,
DisposableBean {
    @Nullable
    private Class providerClass;
    @Nullable
    private ValidationProviderResolver validationProviderResolver;
    @Nullable
    private MessageInterpolator messageInterpolator;
    @Nullable
    private TraversableResolver traversableResolver;
    @Nullable
    private ConstraintValidatorFactory constraintValidatorFactory;
    @Nullable
    private ParameterNameDiscoverer parameterNameDiscoverer;
    @Nullable
    private Resource[] mappingLocations;
    private final Map<String, String> validationPropertyMap = new HashMap<String, String>();
    @Nullable
    private Consumer<Configuration<?>> configurationInitializer;
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private ValidatorFactory validatorFactory;

    public void setProviderClass(Class providerClass) {
        this.providerClass = providerClass;
    }

    public void setValidationProviderResolver(ValidationProviderResolver validationProviderResolver) {
        this.validationProviderResolver = validationProviderResolver;
    }

    public void setMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public void setValidationMessageSource(MessageSource messageSource) {
        this.messageInterpolator = HibernateValidatorDelegate.buildMessageInterpolator(messageSource);
    }

    public void setTraversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
    }

    public void setConstraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setMappingLocations(Resource ... mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public void setValidationProperties(Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap(jpaProperties, this.validationPropertyMap);
    }

    public void setValidationPropertyMap(@Nullable Map<String, String> validationProperties) {
        if (validationProperties != null) {
            this.validationPropertyMap.putAll(validationProperties);
        }
    }

    public Map<String, String> getValidationPropertyMap() {
        return this.validationPropertyMap;
    }

    public void setConfigurationInitializer(Consumer<Configuration<?>> configurationInitializer) {
        this.configurationInitializer = configurationInitializer;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterPropertiesSet() {
        ConstraintValidatorFactory targetConstraintValidatorFactory;
        MessageInterpolator targetInterpolator;
        Configuration<Object> configuration;
        if (this.providerClass != null) {
            bootstrap = Validation.byProvider(this.providerClass);
            if (this.validationProviderResolver != null) {
                bootstrap = bootstrap.providerResolver(this.validationProviderResolver);
            }
            configuration = bootstrap.configure();
        } else {
            bootstrap = Validation.byDefaultProvider();
            if (this.validationProviderResolver != null) {
                bootstrap = bootstrap.providerResolver(this.validationProviderResolver);
            }
            configuration = bootstrap.configure();
        }
        if (this.applicationContext != null) {
            try {
                Method eclMethod = configuration.getClass().getMethod("externalClassLoader", ClassLoader.class);
                ReflectionUtils.invokeMethod(eclMethod, configuration, this.applicationContext.getClassLoader());
            }
            catch (NoSuchMethodException eclMethod) {
                // empty catch block
            }
        }
        if ((targetInterpolator = this.messageInterpolator) == null) {
            targetInterpolator = configuration.getDefaultMessageInterpolator();
        }
        configuration.messageInterpolator(new LocaleContextMessageInterpolator(targetInterpolator));
        if (this.traversableResolver != null) {
            configuration.traversableResolver(this.traversableResolver);
        }
        if ((targetConstraintValidatorFactory = this.constraintValidatorFactory) == null && this.applicationContext != null) {
            targetConstraintValidatorFactory = new SpringConstraintValidatorFactory(this.applicationContext.getAutowireCapableBeanFactory());
        }
        if (targetConstraintValidatorFactory != null) {
            configuration.constraintValidatorFactory(targetConstraintValidatorFactory);
        }
        if (this.parameterNameDiscoverer != null) {
            this.configureParameterNameProvider(this.parameterNameDiscoverer, configuration);
        }
        ArrayList<InputStream> mappingStreams = null;
        if (this.mappingLocations != null) {
            mappingStreams = new ArrayList<InputStream>(this.mappingLocations.length);
            for (Resource location : this.mappingLocations) {
                try {
                    InputStream stream = location.getInputStream();
                    mappingStreams.add(stream);
                    configuration.addMapping(stream);
                }
                catch (IOException ex) {
                    this.closeMappingStreams(mappingStreams);
                    throw new IllegalStateException("Cannot read mapping resource: " + location);
                }
            }
        }
        this.validationPropertyMap.forEach(configuration::addProperty);
        if (this.configurationInitializer != null) {
            this.configurationInitializer.accept(configuration);
        }
        this.postProcessConfiguration(configuration);
        try {
            this.validatorFactory = configuration.buildValidatorFactory();
            this.setTargetValidator(this.validatorFactory.getValidator());
        }
        finally {
            this.closeMappingStreams(mappingStreams);
        }
    }

    private void configureParameterNameProvider(final ParameterNameDiscoverer discoverer, Configuration<?> configuration) {
        final ParameterNameProvider defaultProvider = configuration.getDefaultParameterNameProvider();
        configuration.parameterNameProvider(new ParameterNameProvider(){

            @Override
            public List<String> getParameterNames(Constructor<?> constructor) {
                String[] paramNames = discoverer.getParameterNames(constructor);
                return paramNames != null ? Arrays.asList(paramNames) : defaultProvider.getParameterNames(constructor);
            }

            @Override
            public List<String> getParameterNames(Method method) {
                String[] paramNames = discoverer.getParameterNames(method);
                return paramNames != null ? Arrays.asList(paramNames) : defaultProvider.getParameterNames(method);
            }
        });
    }

    private void closeMappingStreams(@Nullable List<InputStream> mappingStreams) {
        if (!CollectionUtils.isEmpty(mappingStreams)) {
            for (InputStream stream : mappingStreams) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void postProcessConfiguration(Configuration<?> configuration) {
    }

    @Override
    public Validator getValidator() {
        Assert.state(this.validatorFactory != null, "No target ValidatorFactory set");
        return this.validatorFactory.getValidator();
    }

    @Override
    public ValidatorContext usingContext() {
        Assert.state(this.validatorFactory != null, "No target ValidatorFactory set");
        return this.validatorFactory.usingContext();
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        Assert.state(this.validatorFactory != null, "No target ValidatorFactory set");
        return this.validatorFactory.getMessageInterpolator();
    }

    @Override
    public TraversableResolver getTraversableResolver() {
        Assert.state(this.validatorFactory != null, "No target ValidatorFactory set");
        return this.validatorFactory.getTraversableResolver();
    }

    @Override
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        Assert.state(this.validatorFactory != null, "No target ValidatorFactory set");
        return this.validatorFactory.getConstraintValidatorFactory();
    }

    @Override
    public ParameterNameProvider getParameterNameProvider() {
        Assert.state(this.validatorFactory != null, "No target ValidatorFactory set");
        return this.validatorFactory.getParameterNameProvider();
    }

    @Override
    public ClockProvider getClockProvider() {
        Assert.state(this.validatorFactory != null, "No target ValidatorFactory set");
        return this.validatorFactory.getClockProvider();
    }

    @Override
    public <T> T unwrap(@Nullable Class<T> type) {
        if (type == null || !ValidatorFactory.class.isAssignableFrom(type)) {
            try {
                return super.unwrap(type);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
        if (this.validatorFactory != null) {
            try {
                return this.validatorFactory.unwrap(type);
            }
            catch (ValidationException ex) {
                if (ValidatorFactory.class == type) {
                    return (T)this.validatorFactory;
                }
                throw ex;
            }
        }
        throw new ValidationException("Cannot unwrap to " + type);
    }

    @Override
    public void close() {
        if (this.validatorFactory != null) {
            this.validatorFactory.close();
        }
    }

    @Override
    public void destroy() {
        this.close();
    }

    private static class HibernateValidatorDelegate {
        private HibernateValidatorDelegate() {
        }

        public static MessageInterpolator buildMessageInterpolator(MessageSource messageSource) {
            return new ResourceBundleMessageInterpolator(new MessageSourceResourceBundleLocator(messageSource));
        }
    }
}

