/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.InstanceInfo;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class EurekaServiceInstance
implements ServiceInstance {
    private final InstanceInfo instance;

    public EurekaServiceInstance(InstanceInfo instance) {
        Assert.notNull((Object)instance, "Service instance required");
        this.instance = instance;
    }

    public InstanceInfo getInstanceInfo() {
        return this.instance;
    }

    @Override
    public String getInstanceId() {
        return this.instance.getId();
    }

    @Override
    public String getServiceId() {
        return this.instance.getAppName();
    }

    @Override
    public String getHost() {
        return this.instance.getHostName();
    }

    @Override
    public int getPort() {
        if (this.isSecure()) {
            return this.instance.getSecurePort();
        }
        return this.instance.getPort();
    }

    @Override
    public boolean isSecure() {
        return this.instance.isPortEnabled(InstanceInfo.PortType.SECURE);
    }

    @Override
    public URI getUri() {
        return DefaultServiceInstance.getUri(this);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.instance.getMetadata();
    }

    @Override
    public String getScheme() {
        return this.getUri().getScheme();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EurekaServiceInstance that = (EurekaServiceInstance)o;
        return Objects.equals(this.instance, that.instance);
    }

    public int hashCode() {
        return Objects.hash(this.instance);
    }

    public String toString() {
        return new ToStringCreator(this).append("instance", this.instance).toString();
    }
}

