/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.convert.DurationStyle;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.core.env.Environment;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class DiscoveryClientServiceInstanceListSupplier
implements ServiceInstanceListSupplier {
    public static final String SERVICE_DISCOVERY_TIMEOUT = "spring.cloud.loadbalancer.service-discovery.timeout";
    private static final Log LOG = LogFactory.getLog(DiscoveryClientServiceInstanceListSupplier.class);
    private Duration timeout = Duration.ofSeconds(30L);
    private final String serviceId;
    private final Flux<List<ServiceInstance>> serviceInstances;

    public DiscoveryClientServiceInstanceListSupplier(DiscoveryClient delegate, Environment environment2) {
        this.serviceId = environment2.getProperty("loadbalancer.client.name");
        this.resolveTimeout(environment2);
        this.serviceInstances = Flux.defer(() -> Mono.fromCallable(() -> delegate.getInstances(this.serviceId))).timeout(this.timeout, Flux.defer(() -> {
            this.logTimeout();
            return Flux.just(new ArrayList());
        }), Schedulers.boundedElastic()).onErrorResume(error -> {
            this.logException((Throwable)error);
            return Flux.just(new ArrayList());
        });
    }

    public DiscoveryClientServiceInstanceListSupplier(ReactiveDiscoveryClient delegate, Environment environment2) {
        this.serviceId = environment2.getProperty("loadbalancer.client.name");
        this.resolveTimeout(environment2);
        this.serviceInstances = Flux.defer(() -> delegate.getInstances(this.serviceId).collectList().flux().timeout(this.timeout, Flux.defer(() -> {
            this.logTimeout();
            return Flux.just(new ArrayList());
        })).onErrorResume(error -> {
            this.logException((Throwable)error);
            return Flux.just(new ArrayList());
        }));
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return this.serviceInstances;
    }

    private void resolveTimeout(Environment environment2) {
        String providedTimeout = environment2.getProperty(SERVICE_DISCOVERY_TIMEOUT);
        if (providedTimeout != null) {
            this.timeout = DurationStyle.detectAndParse(providedTimeout);
        }
    }

    private void logTimeout() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Timeout occurred while retrieving instances for service %s.The instances could not be retrieved during %s", this.serviceId, this.timeout));
        }
    }

    private void logException(Throwable error) {
        if (LOG.isErrorEnabled()) {
            LOG.error(String.format("Exception occurred while retrieving instances for service %s", this.serviceId), error);
        }
    }
}

