/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class QueryRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String PARAM_KEY = "param";
    public static final String REGEXP_KEY = "regexp";

    public QueryRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(PARAM_KEY, REGEXP_KEY);
    }

    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        return new GatewayPredicate(){

            @Override
            public boolean test(ServerWebExchange exchange2) {
                if (!StringUtils.hasText(config.regexp)) {
                    return exchange2.getRequest().getQueryParams().containsKey(config.param);
                }
                List values = (List)exchange2.getRequest().getQueryParams().get(config.param);
                if (values == null) {
                    return false;
                }
                for (String value : values) {
                    if (value == null || !value.matches(config.regexp)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Object getConfig() {
                return config;
            }

            public String toString() {
                return String.format("Query: param=%s regexp=%s", config.getParam(), config.getRegexp());
            }
        };
    }

    @Validated
    public static class Config {
        @NotEmpty
        private String param;
        private String regexp;

        public String getParam() {
            return this.param;
        }

        public Config setParam(String param) {
            this.param = param;
            return this;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public Config setRegexp(String regexp) {
            this.regexp = regexp;
            return this;
        }
    }
}

