/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers.observation;

import io.micrometer.observation.transport.RequestReplySenderContext;
import java.util.Collections;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;

public class GatewayContext
extends RequestReplySenderContext<HttpHeaders, ServerHttpResponse> {
    private final ServerHttpRequest request;
    private final ServerWebExchange serverWebExchange;

    public GatewayContext(HttpHeaders headers, ServerHttpRequest request, ServerWebExchange serverWebExchange) {
        super((carrier, key, value) -> Objects.requireNonNull(carrier).put(key, Collections.singletonList(value)));
        this.request = request;
        this.serverWebExchange = serverWebExchange;
        this.setCarrier(headers);
    }

    public ServerHttpRequest getRequest() {
        return this.request;
    }

    public ServerWebExchange getServerWebExchange() {
        return this.serverWebExchange;
    }
}

