/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Collections;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SetRequestHostHeaderGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public SetRequestHostHeaderGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("host");
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
                String value = ServerWebExchangeUtils.expand(exchange2, config.getHost());
                ServerHttpRequest request = exchange2.getRequest().mutate().headers(httpHeaders -> {
                    httpHeaders.remove("Host");
                    httpHeaders.add("Host", value);
                }).build();
                exchange2.getAttributes().put(ServerWebExchangeUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, true);
                return chain.filter(exchange2.mutate().request(request).build());
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(SetRequestHostHeaderGatewayFilterFactory.this).append(config.getHost()).toString();
            }
        };
    }

    public static class Config {
        private String host;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }
    }
}

