/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class RewriteRequestParameterGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String REPLACEMENT_KEY = "replacement";

    public RewriteRequestParameterGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name", REPLACEMENT_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
                ServerHttpRequest req = exchange2.getRequest();
                UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUri(req.getURI());
                if (req.getQueryParams().containsKey(config.getName())) {
                    uriComponentsBuilder.replaceQueryParam(config.getName(), config.getReplacement());
                }
                URI uri = uriComponentsBuilder.build().toUri();
                ServerHttpRequest request = req.mutate().uri(uri).build();
                return chain.filter(exchange2.mutate().request(request).build());
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(RewriteRequestParameterGatewayFilterFactory.this).append(config.getName(), config.replacement).toString();
            }
        };
    }

    public static class Config
    extends AbstractGatewayFilterFactory.NameConfig {
        private String replacement;

        public String getReplacement() {
            return this.replacement;
        }

        public Config setReplacement(String replacement) {
            Assert.notNull((Object)replacement, "replacement must not be null");
            this.replacement = replacement;
            return this;
        }
    }
}

