/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Mono;

public class PrefixPathGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String PREFIX_KEY = "prefix";
    private static final Log log = LogFactory.getLog(PrefixPathGatewayFilterFactory.class);

    public PrefixPathGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(PREFIX_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){
            final UriTemplate uriTemplate;
            {
                this.uriTemplate = new UriTemplate(config.prefix);
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
                boolean alreadyPrefixed = exchange2.getAttributeOrDefault(ServerWebExchangeUtils.GATEWAY_ALREADY_PREFIXED_ATTR, false);
                if (alreadyPrefixed) {
                    return chain.filter(exchange2);
                }
                exchange2.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ALREADY_PREFIXED_ATTR, true);
                ServerHttpRequest req = exchange2.getRequest();
                ServerWebExchangeUtils.addOriginalRequestUrl(exchange2, req.getURI());
                Map<String, String> uriVariables = ServerWebExchangeUtils.getUriTemplateVariables(exchange2);
                URI uri = this.uriTemplate.expand(uriVariables);
                String newPath = uri.getRawPath() + req.getURI().getRawPath();
                exchange2.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
                ServerHttpRequest request = req.mutate().path(newPath).build();
                if (log.isTraceEnabled()) {
                    log.trace("Prefixed URI with: " + config.prefix + " -> " + request.getURI());
                }
                return chain.filter(exchange2.mutate().request(request).build());
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(PrefixPathGatewayFilterFactory.this).append(PrefixPathGatewayFilterFactory.PREFIX_KEY, config.getPrefix()).toString();
            }
        };
    }

    public static class Config {
        private String prefix;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }
}

