/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class AddRequestHeadersIfNotPresentGatewayFilterFactory
extends AbstractGatewayFilterFactory<KeyValueConfig> {
    @Override
    public GatewayFilter apply(final KeyValueConfig config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
                ServerHttpRequest.Builder requestBuilder = null;
                HashMap<String, ArrayList<String>> aggregatedHeaders = new HashMap<String, ArrayList<String>>();
                for (KeyValue keyValue : config.getKeyValues()) {
                    String key = keyValue.getKey();
                    ArrayList<String> candidateValue = (ArrayList<String>)aggregatedHeaders.get(key);
                    if (candidateValue == null) {
                        candidateValue = new ArrayList<String>();
                        candidateValue.add(keyValue.getValue());
                    } else {
                        candidateValue.add(keyValue.getValue());
                    }
                    aggregatedHeaders.put(key, candidateValue);
                }
                for (Map.Entry entry : aggregatedHeaders.entrySet()) {
                    String headerName = (String)entry.getKey();
                    boolean headerIsMissingOrBlank = exchange2.getRequest().getHeaders().getOrEmpty(headerName).stream().allMatch(h -> !StringUtils.hasText(h));
                    if (!headerIsMissingOrBlank) continue;
                    if (requestBuilder == null) {
                        requestBuilder = exchange2.getRequest().mutate();
                    }
                    ServerWebExchange finalExchange = exchange2;
                    requestBuilder.headers(httpHeaders -> {
                        List replacedValues = ((List)kv.getValue()).stream().map(value -> ServerWebExchangeUtils.expand(finalExchange, value)).collect(Collectors.toList());
                        httpHeaders.addAll(headerName, replacedValues);
                    });
                }
                if (requestBuilder != null) {
                    exchange2 = exchange2.mutate().request(requestBuilder.build()).build();
                }
                return chain.filter(exchange2);
            }

            public String toString() {
                ToStringCreator toStringCreator = GatewayToStringStyler.filterToStringCreator(AddRequestHeadersIfNotPresentGatewayFilterFactory.this);
                for (KeyValue keyValue : config.getKeyValues()) {
                    toStringCreator.append(keyValue.getKey(), keyValue.getValue());
                }
                return toStringCreator.toString();
            }
        };
    }

    @Override
    public ShortcutConfigurable.ShortcutType shortcutType() {
        return ShortcutConfigurable.ShortcutType.GATHER_LIST;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("keyValues");
    }

    @Override
    public KeyValueConfig newConfig() {
        return new KeyValueConfig();
    }

    @Override
    public Class<KeyValueConfig> getConfigClass() {
        return KeyValueConfig.class;
    }

    @Deprecated
    public static class KeyValueConfig {
        private KeyValue[] keyValues;

        public KeyValue[] getKeyValues() {
            return this.keyValues;
        }

        public void setKeyValues(KeyValue[] keyValues) {
            this.keyValues = keyValues;
        }
    }

    @Deprecated
    public static class KeyValue {
        private final String key;
        private final String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return new ToStringCreator(this).append("name", this.key).append("value", this.value).toString();
        }
    }
}

