/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.HttpRequestLoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestTransformer;
import org.springframework.cloud.client.loadbalancer.ServiceRequestWrapper;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpResponse;

class BlockingLoadBalancerRequest
implements HttpRequestLoadBalancerRequest<ClientHttpResponse> {
    private final LoadBalancerClient loadBalancer;
    private final List<LoadBalancerRequestTransformer> transformers;
    private final ClientHttpRequestData clientHttpRequestData;

    BlockingLoadBalancerRequest(LoadBalancerClient loadBalancer, List<LoadBalancerRequestTransformer> transformers, ClientHttpRequestData clientHttpRequestData) {
        this.loadBalancer = loadBalancer;
        this.transformers = transformers;
        this.clientHttpRequestData = clientHttpRequestData;
    }

    @Override
    public ClientHttpResponse apply(ServiceInstance instance) throws Exception {
        HttpRequest serviceRequest = new ServiceRequestWrapper(this.clientHttpRequestData.request, instance, this.loadBalancer);
        if (this.transformers != null) {
            for (LoadBalancerRequestTransformer transformer : this.transformers) {
                serviceRequest = transformer.transformRequest(serviceRequest, instance);
            }
        }
        return this.clientHttpRequestData.execution.execute(serviceRequest, this.clientHttpRequestData.body);
    }

    @Override
    public HttpRequest getHttpRequest() {
        return this.clientHttpRequestData.request;
    }

    static class ClientHttpRequestData {
        private final HttpRequest request;
        private final byte[] body;
        private final ClientHttpRequestExecution execution;

        ClientHttpRequestData(HttpRequest request, byte[] body2, ClientHttpRequestExecution execution) {
            this.request = request;
            this.body = body2;
            this.execution = execution;
        }
    }
}

