/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple.reactive;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryHealthIndicatorEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ReactiveCommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.composite.reactive.ReactiveCompositeDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnReactiveDiscoveryEnabled
@EnableConfigurationProperties(value={DiscoveryClientHealthIndicatorProperties.class})
@AutoConfigureBefore(value={ReactiveCommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={ReactiveCompositeDiscoveryClientAutoConfiguration.class})
public class SimpleReactiveDiscoveryClientAutoConfiguration
implements ApplicationListener<WebServerInitializedEvent> {
    @Autowired(required=false)
    private ServerProperties server;
    @Value(value="${spring.application.name:application}")
    private String serviceId;
    @Autowired
    private InetUtils inet;
    private int port = 0;
    private SimpleReactiveDiscoveryProperties simple = new SimpleReactiveDiscoveryProperties();

    @Bean
    public SimpleReactiveDiscoveryProperties simpleReactiveDiscoveryProperties() {
        this.simple.getLocal().setServiceId(this.serviceId);
        this.simple.getLocal().setHost(this.inet.findFirstNonLoopbackHostInfo().getHostname());
        this.simple.getLocal().setPort(this.findPort());
        return this.simple;
    }

    @Bean
    @Order
    public SimpleReactiveDiscoveryClient simpleReactiveDiscoveryClient(SimpleReactiveDiscoveryProperties properties) {
        return new SimpleReactiveDiscoveryClient(properties);
    }

    private int findPort() {
        if (this.port > 0) {
            return this.port;
        }
        if (this.server != null && this.server.getPort() != null && this.server.getPort() > 0) {
            return this.server.getPort();
        }
        return 8080;
    }

    @Override
    public void onApplicationEvent(WebServerInitializedEvent webServerInitializedEvent) {
        this.port = webServerInitializedEvent.getWebServer().getPort();
        if (this.port > 0) {
            this.simple.getLocal().setHost(this.inet.findFirstNonLoopbackHostInfo().getHostname());
            this.simple.getLocal().setPort(this.port);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ReactiveHealthIndicator.class})
    protected static class HealthConfiguration {
        protected HealthConfiguration() {
        }

        @Bean
        @ConditionalOnDiscoveryHealthIndicatorEnabled
        public ReactiveDiscoveryClientHealthIndicator simpleReactiveDiscoveryClientHealthIndicator(DiscoveryClientHealthIndicatorProperties properties, SimpleReactiveDiscoveryClient simpleReactiveDiscoveryClient) {
            return new ReactiveDiscoveryClientHealthIndicator(simpleReactiveDiscoveryClient, properties);
        }
    }
}

