/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.type.classreading;

import java.io.IOException;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ConcurrentReferenceHashMap;

public class ConcurrentReferenceCachingMetadataReaderFactory
extends SimpleMetadataReaderFactory {
    private final Map<Resource, MetadataReader> cache = new ConcurrentReferenceHashMap<Resource, MetadataReader>();

    public ConcurrentReferenceCachingMetadataReaderFactory() {
    }

    public ConcurrentReferenceCachingMetadataReaderFactory(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    public ConcurrentReferenceCachingMetadataReaderFactory(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public MetadataReader getMetadataReader(Resource resource2) throws IOException {
        MetadataReader metadataReader = this.cache.get(resource2);
        if (metadataReader == null) {
            metadataReader = this.createMetadataReader(resource2);
            this.cache.put(resource2, metadataReader);
        }
        return metadataReader;
    }

    protected MetadataReader createMetadataReader(Resource resource2) throws IOException {
        return super.getMetadataReader(resource2);
    }

    public void clearCache() {
        this.cache.clear();
    }
}

