/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive;

import java.util.Arrays;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProviders;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;

final class WelcomePageRouterFunctionFactory {
    private final String staticPathPattern;
    private final Resource welcomePage;
    private final boolean welcomePageTemplateExists;

    WelcomePageRouterFunctionFactory(TemplateAvailabilityProviders templateAvailabilityProviders, ApplicationContext applicationContext, String[] staticLocations, String staticPathPattern) {
        this.staticPathPattern = staticPathPattern;
        this.welcomePage = this.getWelcomePage(applicationContext, staticLocations);
        this.welcomePageTemplateExists = this.welcomeTemplateExists(templateAvailabilityProviders, applicationContext);
    }

    private Resource getWelcomePage(ResourceLoader resourceLoader, String[] staticLocations) {
        return Arrays.stream(staticLocations).map(location -> this.getIndexHtml(resourceLoader, (String)location)).filter(this::isReadable).findFirst().orElse(null);
    }

    private Resource getIndexHtml(ResourceLoader resourceLoader, String location) {
        return resourceLoader.getResource(location + "index.html");
    }

    private boolean isReadable(Resource resource2) {
        try {
            return resource2.exists() && resource2.getURL() != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean welcomeTemplateExists(TemplateAvailabilityProviders templateAvailabilityProviders, ApplicationContext applicationContext) {
        return templateAvailabilityProviders.getProvider("index", applicationContext) != null;
    }

    RouterFunction<ServerResponse> createRouterFunction() {
        if (this.welcomePage != null && "/**".equals(this.staticPathPattern)) {
            return RouterFunctions.route(RequestPredicates.GET("/").and(RequestPredicates.accept(MediaType.TEXT_HTML)), req -> ServerResponse.ok().contentType(MediaType.TEXT_HTML).bodyValue(this.welcomePage));
        }
        if (this.welcomePageTemplateExists) {
            return RouterFunctions.route(RequestPredicates.GET("/").and(RequestPredicates.accept(MediaType.TEXT_HTML)), req -> ServerResponse.ok().render("index", new Object[0]));
        }
        return null;
    }
}

