/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveHealthIndicator
implements ReactiveHealthIndicator {
    private static final String NO_MESSAGE = null;
    private static final String DEFAULT_MESSAGE = "Health check failed";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Function<Throwable, String> healthCheckFailedMessage;

    protected AbstractReactiveHealthIndicator() {
        this(NO_MESSAGE);
    }

    protected AbstractReactiveHealthIndicator(String healthCheckFailedMessage) {
        this.healthCheckFailedMessage = ex -> healthCheckFailedMessage;
    }

    protected AbstractReactiveHealthIndicator(Function<Throwable, String> healthCheckFailedMessage) {
        Assert.notNull(healthCheckFailedMessage, "HealthCheckFailedMessage must not be null");
        this.healthCheckFailedMessage = healthCheckFailedMessage;
    }

    @Override
    public final Mono<Health> health() {
        try {
            Health.Builder builder = new Health.Builder();
            Mono<Health> result = this.doHealthCheck(builder).onErrorResume(this::handleFailure);
            return result.doOnNext(health -> this.logExceptionIfPresent(builder.getException()));
        }
        catch (Exception ex) {
            return this.handleFailure(ex);
        }
    }

    private void logExceptionIfPresent(Throwable ex) {
        if (ex != null && this.logger.isWarnEnabled()) {
            String message = ex instanceof Exception ? this.healthCheckFailedMessage.apply(ex) : null;
            this.logger.warn(StringUtils.hasText(message) ? message : DEFAULT_MESSAGE, ex);
        }
    }

    private Mono<Health> handleFailure(Throwable ex) {
        this.logExceptionIfPresent(ex);
        return Mono.just(new Health.Builder().down(ex).build());
    }

    protected abstract Mono<Health> doHealthCheck(Health.Builder var1);
}

