/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.reactive;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.annotation.Reflective;
import org.springframework.aot.hint.annotation.ReflectiveRuntimeHintsRegistrar;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.reactive.AbstractWebFluxEndpointHandlerMapping;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;

@ImportRuntimeHints(value={WebFluxEndpointHandlerMappingRuntimeHints.class})
public class WebFluxEndpointHandlerMapping
extends AbstractWebFluxEndpointHandlerMapping
implements InitializingBean {
    private final EndpointLinksResolver linksResolver;

    public WebFluxEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<ExposableWebEndpoint> endpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration, EndpointLinksResolver linksResolver, boolean shouldRegisterLinksMapping) {
        super(endpointMapping, endpoints, endpointMediaTypes, corsConfiguration, shouldRegisterLinksMapping);
        this.linksResolver = linksResolver;
        this.setOrder(-100);
    }

    @Override
    protected AbstractWebFluxEndpointHandlerMapping.LinksHandler getLinksHandler() {
        return new WebFluxLinksHandler();
    }

    class WebFluxLinksHandler
    implements AbstractWebFluxEndpointHandlerMapping.LinksHandler {
        WebFluxLinksHandler() {
        }

        @Override
        @ResponseBody
        @Reflective
        public Map<String, Map<String, Link>> links(ServerWebExchange exchange2) {
            String requestUri = UriComponentsBuilder.fromUri(exchange2.getRequest().getURI()).replaceQuery(null).toUriString();
            Map<String, Link> links = WebFluxEndpointHandlerMapping.this.linksResolver.resolveLinks(requestUri);
            return OperationResponseBody.of(Collections.singletonMap("_links", links));
        }

        public String toString() {
            return "Actuator root web endpoint";
        }
    }

    static class WebFluxEndpointHandlerMappingRuntimeHints
    implements RuntimeHintsRegistrar {
        private final ReflectiveRuntimeHintsRegistrar reflectiveRegistrar = new ReflectiveRuntimeHintsRegistrar();
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        WebFluxEndpointHandlerMappingRuntimeHints() {
        }

        @Override
        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            this.reflectiveRegistrar.registerRuntimeHints(hints, WebFluxLinksHandler.class);
            this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Link.class});
        }
    }
}

