/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.servlet;

import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.servlet.CompositeHandlerAdapter;
import org.springframework.boot.actuate.autoconfigure.web.servlet.CompositeHandlerExceptionResolver;
import org.springframework.boot.actuate.autoconfigure.web.servlet.CompositeHandlerMapping;
import org.springframework.boot.actuate.autoconfigure.web.servlet.ManagementErrorEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletRegistrationBean;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.filter.OrderedRequestContextFilter;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.filter.RequestContextFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@ManagementContextConfiguration(value=ManagementContextType.CHILD, proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={DispatcherServlet.class})
@EnableWebMvc
class WebMvcEndpointChildContextConfiguration {
    WebMvcEndpointChildContextConfiguration() {
    }

    @Bean
    @ConditionalOnBean(value={ErrorAttributes.class})
    ManagementErrorEndpoint errorEndpoint(ErrorAttributes errorAttributes, ServerProperties serverProperties) {
        return new ManagementErrorEndpoint(errorAttributes, serverProperties.getError());
    }

    @Bean
    @ConditionalOnBean(value={ErrorAttributes.class})
    ManagementErrorPageCustomizer managementErrorPageCustomizer(ServerProperties serverProperties) {
        return new ManagementErrorPageCustomizer(serverProperties);
    }

    @Bean(name={"dispatcherServlet"})
    DispatcherServlet dispatcherServlet() {
        DispatcherServlet dispatcherServlet = new DispatcherServlet();
        dispatcherServlet.setDetectAllHandlerAdapters(false);
        dispatcherServlet.setDetectAllHandlerExceptionResolvers(false);
        dispatcherServlet.setDetectAllHandlerMappings(false);
        dispatcherServlet.setDetectAllViewResolvers(false);
        return dispatcherServlet;
    }

    @Bean(name={"dispatcherServletRegistration"})
    DispatcherServletRegistrationBean dispatcherServletRegistrationBean(DispatcherServlet dispatcherServlet) {
        return new DispatcherServletRegistrationBean(dispatcherServlet, "/");
    }

    @Bean(name={"handlerMapping"})
    CompositeHandlerMapping compositeHandlerMapping() {
        return new CompositeHandlerMapping();
    }

    @Bean(name={"handlerAdapter"})
    CompositeHandlerAdapter compositeHandlerAdapter(ListableBeanFactory beanFactory) {
        return new CompositeHandlerAdapter(beanFactory);
    }

    @Bean(name={"handlerExceptionResolver"})
    CompositeHandlerExceptionResolver compositeHandlerExceptionResolver() {
        return new CompositeHandlerExceptionResolver();
    }

    @Bean
    @ConditionalOnMissingBean(value={RequestContextListener.class, RequestContextFilter.class})
    RequestContextFilter requestContextFilter() {
        return new OrderedRequestContextFilter();
    }

    static class ManagementErrorPageCustomizer
    implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory>,
    Ordered {
        private final ServerProperties properties;

        ManagementErrorPageCustomizer(ServerProperties properties) {
            this.properties = properties;
        }

        @Override
        public void customize(ConfigurableServletWebServerFactory factory) {
            factory.addErrorPages(new ErrorPage(this.properties.getError().getPath()));
        }

        @Override
        public int getOrder() {
            return 0;
        }
    }
}

