/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.annotation.Reflective;
import org.springframework.aot.hint.annotation.ReflectiveRuntimeHintsRegistrar;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.AccessLevel;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.SecurityResponse;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.CloudFoundrySecurityInterceptor;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.reactive.AbstractWebFluxEndpointHandlerMapping;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@ImportRuntimeHints(value={CloudFoundryWebFluxEndpointHandlerMappingRuntimeHints.class})
class CloudFoundryWebFluxEndpointHandlerMapping
extends AbstractWebFluxEndpointHandlerMapping {
    private final CloudFoundrySecurityInterceptor securityInterceptor;
    private final EndpointLinksResolver linksResolver;
    private final Collection<ExposableEndpoint<?>> allEndpoints;

    CloudFoundryWebFluxEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<ExposableWebEndpoint> endpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration, CloudFoundrySecurityInterceptor securityInterceptor, Collection<ExposableEndpoint<?>> allEndpoints) {
        super(endpointMapping, endpoints, endpointMediaTypes, corsConfiguration, true);
        this.linksResolver = new EndpointLinksResolver(allEndpoints);
        this.allEndpoints = allEndpoints;
        this.securityInterceptor = securityInterceptor;
    }

    @Override
    protected AbstractWebFluxEndpointHandlerMapping.ReactiveWebOperation wrapReactiveWebOperation(ExposableWebEndpoint endpoint, WebOperation operation, AbstractWebFluxEndpointHandlerMapping.ReactiveWebOperation reactiveWebOperation) {
        return new SecureReactiveWebOperation(reactiveWebOperation, this.securityInterceptor, endpoint.getEndpointId());
    }

    @Override
    protected AbstractWebFluxEndpointHandlerMapping.LinksHandler getLinksHandler() {
        return new CloudFoundryLinksHandler();
    }

    Collection<ExposableEndpoint<?>> getAllEndpoints() {
        return this.allEndpoints;
    }

    private static class SecureReactiveWebOperation
    implements AbstractWebFluxEndpointHandlerMapping.ReactiveWebOperation {
        private final AbstractWebFluxEndpointHandlerMapping.ReactiveWebOperation delegate;
        private final CloudFoundrySecurityInterceptor securityInterceptor;
        private final EndpointId endpointId;

        SecureReactiveWebOperation(AbstractWebFluxEndpointHandlerMapping.ReactiveWebOperation delegate, CloudFoundrySecurityInterceptor securityInterceptor, EndpointId endpointId) {
            this.delegate = delegate;
            this.securityInterceptor = securityInterceptor;
            this.endpointId = endpointId;
        }

        @Override
        public Mono<ResponseEntity<Object>> handle(ServerWebExchange exchange2, Map<String, String> body2) {
            return this.securityInterceptor.preHandle(exchange2, this.endpointId.toLowerCaseString()).flatMap(securityResponse -> this.flatMapResponse(exchange2, body2, (SecurityResponse)securityResponse));
        }

        private Mono<ResponseEntity<Object>> flatMapResponse(ServerWebExchange exchange2, Map<String, String> body2, SecurityResponse securityResponse) {
            if (!securityResponse.getStatus().equals(HttpStatus.OK)) {
                return Mono.just(new ResponseEntity(securityResponse.getStatus()));
            }
            return this.delegate.handle(exchange2, body2);
        }
    }

    class CloudFoundryLinksHandler
    implements AbstractWebFluxEndpointHandlerMapping.LinksHandler {
        CloudFoundryLinksHandler() {
        }

        @Override
        @Reflective
        public Publisher<ResponseEntity<Object>> links(ServerWebExchange exchange2) {
            ServerHttpRequest request = exchange2.getRequest();
            return CloudFoundryWebFluxEndpointHandlerMapping.this.securityInterceptor.preHandle(exchange2, "").map(securityResponse -> {
                if (!securityResponse.getStatus().equals(HttpStatus.OK)) {
                    return new ResponseEntity(securityResponse.getStatus());
                }
                AccessLevel accessLevel = (AccessLevel)((Object)((Object)exchange2.getAttribute("cloudFoundryAccessLevel")));
                Map<String, Link> links = CloudFoundryWebFluxEndpointHandlerMapping.this.linksResolver.resolveLinks(request.getURI().toString());
                return new ResponseEntity<Map<String, Map<String, Link>>>(Collections.singletonMap("_links", this.getAccessibleLinks(accessLevel, links)), (HttpStatusCode)HttpStatus.OK);
            });
        }

        private Map<String, Link> getAccessibleLinks(AccessLevel accessLevel, Map<String, Link> links) {
            if (accessLevel == null) {
                return new LinkedHashMap<String, Link>();
            }
            return links.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("self") || accessLevel.isAccessAllowed((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public String toString() {
            return "Actuator root web endpoint";
        }
    }

    static class CloudFoundryWebFluxEndpointHandlerMappingRuntimeHints
    implements RuntimeHintsRegistrar {
        private final ReflectiveRuntimeHintsRegistrar reflectiveRegistrar = new ReflectiveRuntimeHintsRegistrar();
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        CloudFoundryWebFluxEndpointHandlerMappingRuntimeHints() {
        }

        @Override
        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            this.reflectiveRegistrar.registerRuntimeHints(hints, CloudFoundryLinksHandler.class);
            this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Link.class});
        }
    }
}

