/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.kyber;

import org.bouncycastle.pqc.crypto.crystals.kyber.CBD;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberEngine;
import org.bouncycastle.pqc.crypto.crystals.kyber.Ntt;
import org.bouncycastle.pqc.crypto.crystals.kyber.Reduce;
import org.bouncycastle.pqc.crypto.crystals.kyber.Symmetric;

class Poly {
    private short[] coeffs = new short[256];
    private KyberEngine engine;
    private int polyCompressedBytes;
    private int eta1;
    private int eta2;
    private Symmetric symmetric;

    public Poly(KyberEngine kyberEngine) {
        this.engine = kyberEngine;
        this.polyCompressedBytes = kyberEngine.getKyberPolyCompressedBytes();
        this.eta1 = kyberEngine.getKyberEta1();
        this.eta2 = KyberEngine.getKyberEta2();
        this.symmetric = kyberEngine.getSymmetric();
    }

    public short getCoeffIndex(int n) {
        return this.coeffs[n];
    }

    public short[] getCoeffs() {
        return this.coeffs;
    }

    public void setCoeffIndex(int n, short s) {
        this.coeffs[n] = s;
    }

    public void setCoeffs(short[] sArray) {
        this.coeffs = sArray;
    }

    public void polyNtt() {
        this.setCoeffs(Ntt.ntt(this.getCoeffs()));
        this.reduce();
    }

    public void polyInverseNttToMont() {
        this.setCoeffs(Ntt.invNtt(this.getCoeffs()));
    }

    public void reduce() {
        for (int j = 0; j < 256; ++j) {
            this.setCoeffIndex(j, Reduce.barretReduce(this.getCoeffIndex(j)));
        }
    }

    public static void baseMultMontgomery(Poly poly, Poly poly2, Poly poly3) {
        for (int j = 0; j < 64; ++j) {
            Ntt.baseMult(poly, 4 * j, poly2.getCoeffIndex(4 * j), poly2.getCoeffIndex(4 * j + 1), poly3.getCoeffIndex(4 * j), poly3.getCoeffIndex(4 * j + 1), Ntt.nttZetas[64 + j]);
            Ntt.baseMult(poly, 4 * j + 2, poly2.getCoeffIndex(4 * j + 2), poly2.getCoeffIndex(4 * j + 3), poly3.getCoeffIndex(4 * j + 2), poly3.getCoeffIndex(4 * j + 3), (short)(-1 * Ntt.nttZetas[64 + j]));
        }
    }

    public void addCoeffs(Poly poly) {
        for (int j = 0; j < 256; ++j) {
            this.setCoeffIndex(j, (short)(this.getCoeffIndex(j) + poly.getCoeffIndex(j)));
        }
    }

    public void convertToMont() {
        for (int j = 0; j < 256; ++j) {
            this.setCoeffIndex(j, Reduce.montgomeryReduce(this.getCoeffIndex(j) * 1353));
        }
    }

    public byte[] compressPoly() {
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[this.polyCompressedBytes];
        int n = 0;
        this.conditionalSubQ();
        if (this.polyCompressedBytes == 128) {
            for (int j = 0; j < 32; ++j) {
                for (int k = 0; k < 8; ++k) {
                    byArray[k] = (byte)(((this.getCoeffIndex(8 * j + k) << 4) + 1664) / 3329 & 0xF);
                }
                byArray2[n + 0] = (byte)(byArray[0] | byArray[1] << 4);
                byArray2[n + 1] = (byte)(byArray[2] | byArray[3] << 4);
                byArray2[n + 2] = (byte)(byArray[4] | byArray[5] << 4);
                byArray2[n + 3] = (byte)(byArray[6] | byArray[7] << 4);
                n += 4;
            }
        } else if (this.polyCompressedBytes == 160) {
            for (int j = 0; j < 32; ++j) {
                for (int k = 0; k < 8; ++k) {
                    byArray[k] = (byte)(((this.getCoeffIndex(8 * j + k) << 5) + 1664) / 3329 & 0x1F);
                }
                byArray2[n + 0] = (byte)(byArray[0] >> 0 | byArray[1] << 5);
                byArray2[n + 1] = (byte)(byArray[1] >> 3 | byArray[2] << 2 | byArray[3] << 7);
                byArray2[n + 2] = (byte)(byArray[3] >> 1 | byArray[4] << 4);
                byArray2[n + 3] = (byte)(byArray[4] >> 4 | byArray[5] << 1 | byArray[6] << 6);
                byArray2[n + 4] = (byte)(byArray[6] >> 2 | byArray[7] << 3);
                n += 5;
            }
        } else {
            throw new RuntimeException("PolyCompressedBytes is neither 128 or 160!");
        }
        return byArray2;
    }

    public void decompressPoly(byte[] byArray) {
        int n = 0;
        if (this.engine.getKyberPolyCompressedBytes() == 128) {
            for (int j = 0; j < 128; ++j) {
                this.setCoeffIndex(2 * j + 0, (short)((short)(byArray[n] & 0xFF & 0xF) * 3329 + 8 >> 4));
                this.setCoeffIndex(2 * j + 1, (short)((short)((byArray[n] & 0xFF) >> 4) * 3329 + 8 >> 4));
                ++n;
            }
        } else if (this.engine.getKyberPolyCompressedBytes() == 160) {
            byte[] byArray2 = new byte[8];
            for (int j = 0; j < 32; ++j) {
                byArray2[0] = (byte)((byArray[n + 0] & 0xFF) >> 0);
                byArray2[1] = (byte)((byArray[n + 0] & 0xFF) >> 5 | (byArray[n + 1] & 0xFF) << 3);
                byArray2[2] = (byte)((byArray[n + 1] & 0xFF) >> 2);
                byArray2[3] = (byte)((byArray[n + 1] & 0xFF) >> 7 | (byArray[n + 2] & 0xFF) << 1);
                byArray2[4] = (byte)((byArray[n + 2] & 0xFF) >> 4 | (byArray[n + 3] & 0xFF) << 4);
                byArray2[5] = (byte)((byArray[n + 3] & 0xFF) >> 1);
                byArray2[6] = (byte)((byArray[n + 3] & 0xFF) >> 6 | (byArray[n + 4] & 0xFF) << 2);
                byArray2[7] = (byte)((byArray[n + 4] & 0xFF) >> 3);
                n += 5;
                for (int k = 0; k < 8; ++k) {
                    this.setCoeffIndex(8 * j + k, (short)((byArray2[k] & 0x1F) * 3329 + 16 >> 5));
                }
            }
        } else {
            throw new RuntimeException("PolyCompressedBytes is neither 128 or 160!");
        }
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[384];
        this.conditionalSubQ();
        for (int j = 0; j < 128; ++j) {
            short s = this.getCoeffIndex(2 * j);
            short s2 = this.getCoeffIndex(2 * j + 1);
            byArray[3 * j] = (byte)(s >> 0);
            byArray[3 * j + 1] = (byte)(s >> 8 | s2 << 4);
            byArray[3 * j + 2] = (byte)(s2 >> 4);
        }
        return byArray;
    }

    public void fromBytes(byte[] byArray) {
        for (int j = 0; j < 128; ++j) {
            this.setCoeffIndex(2 * j, (short)(((byArray[3 * j + 0] & 0xFF) >> 0 | (byArray[3 * j + 1] & 0xFF) << 8) & 0xFFF));
            this.setCoeffIndex(2 * j + 1, (short)(((long)((byArray[3 * j + 1] & 0xFF) >> 4) | (long)((byArray[3 * j + 2] & 0xFF) << 4)) & 0xFFFL));
        }
    }

    public byte[] toMsg() {
        byte[] byArray = new byte[KyberEngine.getKyberIndCpaMsgBytes()];
        this.conditionalSubQ();
        for (int j = 0; j < 32; ++j) {
            byArray[j] = 0;
            for (int k = 0; k < 8; ++k) {
                short s = (short)(((short)(this.getCoeffIndex(8 * j + k) << 1) + 1664) / 3329 & 1);
                int n = j;
                byArray[n] = (byte)(byArray[n] | (byte)(s << k));
            }
        }
        return byArray;
    }

    public void fromMsg(byte[] byArray) {
        if (byArray.length != 32) {
            throw new RuntimeException("KYBER_INDCPA_MSGBYTES must be equal to KYBER_N/8 bytes!");
        }
        for (int j = 0; j < 32; ++j) {
            for (int k = 0; k < 8; ++k) {
                short s = (short)(-1 * (short)((byArray[j] & 0xFF) >> k & 1));
                this.setCoeffIndex(8 * j + k, (short)(s & 0x681));
            }
        }
    }

    public void conditionalSubQ() {
        for (int j = 0; j < 256; ++j) {
            this.setCoeffIndex(j, Reduce.conditionalSubQ(this.getCoeffIndex(j)));
        }
    }

    public void getEta1Noise(byte[] byArray, byte by) {
        byte[] byArray2 = new byte[256 * this.eta1 / 4];
        this.symmetric.prf(byArray2, byArray, by);
        CBD.kyberCBD(this, byArray2, this.eta1);
    }

    public void getEta2Noise(byte[] byArray, byte by) {
        byte[] byArray2 = new byte[256 * this.eta2 / 4];
        this.symmetric.prf(byArray2, byArray, by);
        CBD.kyberCBD(this, byArray2, this.eta2);
    }

    public void polySubtract(Poly poly) {
        for (int j = 0; j < 256; ++j) {
            this.setCoeffIndex(j, (short)(poly.getCoeffIndex(j) - this.getCoeffIndex(j)));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int j = 0; j < this.coeffs.length; ++j) {
            stringBuffer.append(this.coeffs[j]);
            if (j == this.coeffs.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

