/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.clustering;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.math.stat.clustering.Clusterable;
import org.apache.commons.math.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EuclideanIntegerPoint
implements Clusterable<EuclideanIntegerPoint>,
Serializable {
    private static final long serialVersionUID = 3946024775784901369L;
    private final int[] point;

    public EuclideanIntegerPoint(int[] point) {
        this.point = point;
    }

    public int[] getPoint() {
        return this.point;
    }

    @Override
    public double distanceFrom(EuclideanIntegerPoint p) {
        return MathUtils.distance(this.point, p.getPoint());
    }

    @Override
    public EuclideanIntegerPoint centroidOf(Collection<EuclideanIntegerPoint> points) {
        int[] centroid = new int[this.getPoint().length];
        for (EuclideanIntegerPoint p : points) {
            for (int i2 = 0; i2 < centroid.length; ++i2) {
                int n = i2;
                centroid[n] = centroid[n] + p.getPoint()[i2];
            }
        }
        int i3 = 0;
        while (i3 < centroid.length) {
            int n = i3++;
            centroid[n] = centroid[n] / points.size();
        }
        return new EuclideanIntegerPoint(centroid);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EuclideanIntegerPoint)) {
            return false;
        }
        int[] otherPoint = ((EuclideanIntegerPoint)other).getPoint();
        if (this.point.length != otherPoint.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.point.length; ++i2) {
            if (this.point[i2] == otherPoint[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        int[] arr$ = this.point;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer i2 = arr$[i$];
            hashCode += i2.hashCode() * 13 + 7;
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("(");
        int[] coordinates = this.getPoint();
        for (int i2 = 0; i2 < coordinates.length; ++i2) {
            buff.append(coordinates[i2]);
            if (i2 >= coordinates.length - 1) continue;
            buff.append(",");
        }
        buff.append(")");
        return buff.toString();
    }
}

