/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import org.apache.commons.math.optimization.VectorialConvergenceChecker;
import org.apache.commons.math.optimization.VectorialPointValuePair;
import org.apache.commons.math.util.FastMath;

public class SimpleVectorialValueChecker
implements VectorialConvergenceChecker {
    private static final double DEFAULT_RELATIVE_THRESHOLD = (double)1.110223E-14f;
    private static final double DEFAULT_ABSOLUTE_THRESHOLD = 2.2250738585072014E-306;
    private final double relativeThreshold;
    private final double absoluteThreshold;

    public SimpleVectorialValueChecker() {
        this.relativeThreshold = 1.110223E-14f;
        this.absoluteThreshold = 2.2250738585072014E-306;
    }

    public SimpleVectorialValueChecker(double relativeThreshold, double absoluteThreshold) {
        this.relativeThreshold = relativeThreshold;
        this.absoluteThreshold = absoluteThreshold;
    }

    public boolean converged(int iteration, VectorialPointValuePair previous, VectorialPointValuePair current) {
        double[] p = previous.getValueRef();
        double[] c = current.getValueRef();
        for (int i2 = 0; i2 < p.length; ++i2) {
            double size;
            double pi = p[i2];
            double ci = c[i2];
            double difference = FastMath.abs(pi - ci);
            if (!(difference > (size = FastMath.max(FastMath.abs(pi), FastMath.abs(ci))) * this.relativeThreshold) || !(difference > this.absoluteThreshold)) continue;
            return false;
        }
        return true;
    }
}

