/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.jms;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.jakarta9.instrument.jms.JmsObservationDocumentation;
import io.micrometer.jakarta9.instrument.jms.JmsProcessObservationContext;
import io.micrometer.jakarta9.instrument.jms.JmsProcessObservationConvention;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;

public class DefaultJmsProcessObservationConvention
implements JmsProcessObservationConvention {
    private static final KeyValue DESTINATION_TEMPORARY = KeyValue.of(JmsObservationDocumentation.LowCardinalityKeyNames.DESTINATION_TEMPORARY, "true");
    private static final KeyValue DESTINATION_DURABLE = KeyValue.of(JmsObservationDocumentation.LowCardinalityKeyNames.DESTINATION_TEMPORARY, "false");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of(JmsObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, "none");
    private static final KeyValue OPERATION_PROCESS = KeyValue.of(JmsObservationDocumentation.LowCardinalityKeyNames.OPERATION, "process");
    private static final KeyValue DESTINATION_NAME_UNKNOWN = KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, "unknown");
    private static final KeyValue MESSAGE_CONVERSATION_ID_UNKNOWN = KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.CONVERSATION_ID, "unknown");
    private static final KeyValue MESSAGE_ID_UNKNOWN = KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.MESSAGE_ID, "unknown");

    @Override
    public String getName() {
        return "jms.message.process";
    }

    @Override
    public String getContextualName(JmsProcessObservationContext context) {
        return this.destinationName(context).getValue() + " process";
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(JmsProcessObservationContext context) {
        return KeyValues.of(this.exception(context), OPERATION_PROCESS, this.temporaryDestination(context));
    }

    private KeyValue exception(JmsProcessObservationContext context) {
        Throwable error = context.getError();
        if (error != null) {
            String simpleName = error.getClass().getSimpleName();
            return KeyValue.of(JmsObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, !simpleName.isEmpty() ? simpleName : error.getClass().getName());
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue temporaryDestination(JmsProcessObservationContext context) {
        try {
            Message message = (Message)context.getCarrier();
            Destination destination = message.getJMSDestination();
            if (destination instanceof TemporaryQueue || destination instanceof TemporaryTopic) {
                return DESTINATION_TEMPORARY;
            }
            return DESTINATION_DURABLE;
        }
        catch (JMSException exc) {
            return DESTINATION_DURABLE;
        }
    }

    @Override
    public KeyValues getHighCardinalityKeyValues(JmsProcessObservationContext context) {
        return KeyValues.of(this.correlationId(context), this.destinationName(context), this.messageId(context));
    }

    protected KeyValue correlationId(JmsProcessObservationContext context) {
        try {
            Message message = (Message)context.getCarrier();
            if (message.getJMSCorrelationID() == null) {
                return MESSAGE_CONVERSATION_ID_UNKNOWN;
            }
            return KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.CONVERSATION_ID, message.getJMSCorrelationID());
        }
        catch (JMSException exc) {
            return MESSAGE_CONVERSATION_ID_UNKNOWN;
        }
    }

    protected KeyValue destinationName(JmsProcessObservationContext context) {
        try {
            Destination jmsDestination = ((Message)context.getCarrier()).getJMSDestination();
            if (jmsDestination instanceof Queue) {
                Queue queue = (Queue)jmsDestination;
                return KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, queue.getQueueName());
            }
            if (jmsDestination instanceof Topic) {
                Topic topic = (Topic)jmsDestination;
                return KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, topic.getTopicName());
            }
            return DESTINATION_NAME_UNKNOWN;
        }
        catch (JMSException e) {
            return DESTINATION_NAME_UNKNOWN;
        }
    }

    protected KeyValue messageId(JmsProcessObservationContext context) {
        try {
            Message message = (Message)context.getCarrier();
            if (message.getJMSMessageID() == null) {
                return MESSAGE_ID_UNKNOWN;
            }
            return KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.MESSAGE_ID, message.getJMSMessageID());
        }
        catch (JMSException exc) {
            return MESSAGE_ID_UNKNOWN;
        }
    }
}

