/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.google.common.base.Preconditions;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.impl.conn.tsccm.RouteSpecificPool;
import org.apache.http.impl.conn.tsccm.WaitingThreadAborter;
import org.apache.http.params.HttpParams;

public class NamedConnectionPool
extends ConnPoolByRoute {
    private Counter freeEntryCounter;
    private Counter createEntryCounter;
    private Counter requestCounter;
    private Counter releaseCounter;
    private Counter deleteCounter;
    private Timer requestTimer;
    private Timer creationTimer;
    private String name;

    public NamedConnectionPool(String name, ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections, long connTTL, TimeUnit connTTLTimeUnit) {
        super(operator, connPerRoute, maxTotalConnections, connTTL, connTTLTimeUnit);
        this.initMonitors(name);
    }

    public NamedConnectionPool(String name, ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections) {
        super(operator, connPerRoute, maxTotalConnections);
        this.initMonitors(name);
    }

    public NamedConnectionPool(String name, ClientConnectionOperator operator, HttpParams params) {
        super(operator, params);
        this.initMonitors(name);
    }

    NamedConnectionPool(ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections, long connTTL, TimeUnit connTTLTimeUnit) {
        super(operator, connPerRoute, maxTotalConnections, connTTL, connTTLTimeUnit);
    }

    NamedConnectionPool(ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections) {
        super(operator, connPerRoute, maxTotalConnections);
    }

    NamedConnectionPool(ClientConnectionOperator operator, HttpParams params) {
        super(operator, params);
    }

    void initMonitors(String name) {
        Preconditions.checkNotNull(name);
        this.freeEntryCounter = Monitors.newCounter(name + "_Reuse");
        this.createEntryCounter = Monitors.newCounter(name + "_CreateNew");
        this.requestCounter = Monitors.newCounter(name + "_Request");
        this.releaseCounter = Monitors.newCounter(name + "_Release");
        this.deleteCounter = Monitors.newCounter(name + "_Delete");
        this.requestTimer = Monitors.newTimer(name + "_RequestConnectionTimer", TimeUnit.MILLISECONDS);
        this.creationTimer = Monitors.newTimer(name + "_CreateConnectionTimer", TimeUnit.MILLISECONDS);
        this.name = name;
        Monitors.registerObject(name, this);
    }

    @Override
    public PoolEntryRequest requestPoolEntry(HttpRoute route, Object state) {
        this.requestCounter.increment();
        return super.requestPoolEntry(route, state);
    }

    @Override
    protected BasicPoolEntry getFreeEntry(RouteSpecificPool rospl, Object state) {
        BasicPoolEntry entry = super.getFreeEntry(rospl, state);
        if (entry != null) {
            this.freeEntryCounter.increment();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BasicPoolEntry createEntry(RouteSpecificPool rospl, ClientConnectionOperator op) {
        this.createEntryCounter.increment();
        Stopwatch stopWatch = this.creationTimer.start();
        try {
            BasicPoolEntry basicPoolEntry = super.createEntry(rospl, op);
            return basicPoolEntry;
        }
        finally {
            stopWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BasicPoolEntry getEntryBlocking(HttpRoute route, Object state, long timeout, TimeUnit tunit, WaitingThreadAborter aborter) throws ConnectionPoolTimeoutException, InterruptedException {
        Stopwatch stopWatch = this.requestTimer.start();
        try {
            BasicPoolEntry basicPoolEntry = super.getEntryBlocking(route, state, timeout, tunit, aborter);
            return basicPoolEntry;
        }
        finally {
            stopWatch.stop();
        }
    }

    @Override
    public void freeEntry(BasicPoolEntry entry, boolean reusable, long validDuration, TimeUnit timeUnit) {
        this.releaseCounter.increment();
        super.freeEntry(entry, reusable, validDuration, timeUnit);
    }

    @Override
    protected void deleteEntry(BasicPoolEntry entry) {
        this.deleteCounter.increment();
        super.deleteEntry(entry);
    }

    public final long getFreeEntryCount() {
        return ((Number)this.freeEntryCounter.getValue()).longValue();
    }

    public final long getCreatedEntryCount() {
        return ((Number)this.createEntryCounter.getValue()).longValue();
    }

    public final long getRequestsCount() {
        return ((Number)this.requestCounter.getValue()).longValue();
    }

    public final long getReleaseCount() {
        return ((Number)this.releaseCounter.getValue()).longValue();
    }

    public final long getDeleteCount() {
        return ((Number)this.deleteCounter.getValue()).longValue();
    }

    @Monitor(name="connectionCount", type=DataSourceType.GAUGE)
    public int getConnectionCount() {
        return this.getConnectionsInPool();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (Monitors.isObjectRegistered(this.name, this)) {
            Monitors.unregisterObject(this.name, this);
        }
    }
}

