/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.jersey.TransportClientFactories;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.util.ReflectionUtils;

public class CloudEurekaClient
extends DiscoveryClient {
    private static final Log log = LogFactory.getLog(CloudEurekaClient.class);
    private final AtomicLong cacheRefreshedCount = new AtomicLong(0L);
    private final ApplicationEventPublisher publisher;
    private final Field eurekaTransportField;
    private final ApplicationInfoManager applicationInfoManager;
    private final AtomicReference<EurekaHttpClient> eurekaHttpClient = new AtomicReference();

    public CloudEurekaClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, TransportClientFactories transportClientFactories, ApplicationEventPublisher publisher) {
        this(applicationInfoManager, config, transportClientFactories, null, publisher);
    }

    public CloudEurekaClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, TransportClientFactories transportClientFactories, AbstractDiscoveryClientOptionalArgs<?> args, ApplicationEventPublisher publisher) {
        super(applicationInfoManager, config, transportClientFactories, args);
        this.applicationInfoManager = applicationInfoManager;
        this.publisher = publisher;
        this.eurekaTransportField = ReflectionUtils.findField(DiscoveryClient.class, "eurekaTransport");
        ReflectionUtils.makeAccessible(this.eurekaTransportField);
    }

    @Override
    public ApplicationInfoManager getApplicationInfoManager() {
        return this.applicationInfoManager;
    }

    public void cancelOverrideStatus(InstanceInfo info) {
        this.getEurekaHttpClient().deleteStatusOverride(info.getAppName(), info.getId(), info);
    }

    public InstanceInfo getInstanceInfo(String appname, String instanceId) {
        EurekaHttpResponse<InstanceInfo> response = this.getEurekaHttpClient().getInstance(appname, instanceId);
        HttpStatus httpStatus = HttpStatus.valueOf(response.getStatusCode());
        if (httpStatus.is2xxSuccessful() && response.getEntity() != null) {
            return response.getEntity();
        }
        return null;
    }

    EurekaHttpClient getEurekaHttpClient() {
        if (this.eurekaHttpClient.get() == null) {
            try {
                Object eurekaTransport = this.eurekaTransportField.get(this);
                Field registrationClientField = ReflectionUtils.findField(eurekaTransport.getClass(), "registrationClient");
                ReflectionUtils.makeAccessible(registrationClientField);
                this.eurekaHttpClient.compareAndSet(null, (EurekaHttpClient)registrationClientField.get(eurekaTransport));
            }
            catch (IllegalAccessException e) {
                log.error("error getting EurekaHttpClient", e);
            }
        }
        return this.eurekaHttpClient.get();
    }

    public void setStatus(InstanceInfo.InstanceStatus newStatus, InstanceInfo info) {
        this.getEurekaHttpClient().statusUpdate(info.getAppName(), info.getId(), newStatus, info);
    }

    @Override
    protected void onCacheRefreshed() {
        super.onCacheRefreshed();
        if (this.cacheRefreshedCount != null) {
            long newCount = this.cacheRefreshedCount.incrementAndGet();
            log.trace("onCacheRefreshed called with count: " + newCount);
            this.publisher.publishEvent(new HeartbeatEvent((Object)this, newCount));
        }
    }
}

