/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.stats;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.util.StringUtils;

final class LoadBalancerTags {
    static final String UNKNOWN = "UNKNOWN";

    private LoadBalancerTags() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    static Iterable<Tag> buildSuccessRequestTags(CompletionContext<Object, ServiceInstance, Object> completionContext) {
        ServiceInstance serviceInstance = completionContext.getLoadBalancerResponse().getServer();
        Tags tags = Tags.of(LoadBalancerTags.buildServiceInstanceTags(serviceInstance));
        Object clientResponse = completionContext.getClientResponse();
        if (clientResponse instanceof ResponseData) {
            ResponseData responseData = (ResponseData)clientResponse;
            RequestData requestData = responseData.getRequestData();
            tags = requestData != null ? tags.and(LoadBalancerTags.valueOrUnknown("method", requestData.getHttpMethod()), LoadBalancerTags.valueOrUnknown("uri", LoadBalancerTags.getPath(requestData))) : tags.and(Tag.of("method", UNKNOWN), Tag.of("uri", UNKNOWN));
            tags = tags.and(Tag.of("outcome", LoadBalancerTags.forStatus(LoadBalancerTags.statusValue(responseData))), LoadBalancerTags.valueOrUnknown("status", LoadBalancerTags.statusValue(responseData)));
        } else {
            tags = tags.and(Tag.of("method", UNKNOWN), Tag.of("uri", UNKNOWN), Tag.of("outcome", UNKNOWN), Tag.of("status", UNKNOWN));
        }
        return tags;
    }

    private static int statusValue(ResponseData responseData) {
        return responseData.getHttpStatus() != null ? responseData.getHttpStatus().value() : 200;
    }

    private static String getPath(RequestData requestData) {
        return requestData.getUrl() != null ? requestData.getUrl().getPath() : UNKNOWN;
    }

    static Iterable<Tag> buildDiscardedRequestTags(CompletionContext<Object, ServiceInstance, Object> completionContext) {
        RequestData requestData;
        if (completionContext.getLoadBalancerRequest().getContext() instanceof RequestDataContext && (requestData = ((RequestDataContext)completionContext.getLoadBalancerRequest().getContext()).getClientRequest()) != null) {
            return Tags.of(LoadBalancerTags.valueOrUnknown("method", requestData.getHttpMethod()), LoadBalancerTags.valueOrUnknown("uri", LoadBalancerTags.getPath(requestData)), LoadBalancerTags.valueOrUnknown("serviceId", LoadBalancerTags.getHost(requestData)));
        }
        return Tags.of(LoadBalancerTags.valueOrUnknown("method", UNKNOWN), LoadBalancerTags.valueOrUnknown("uri", UNKNOWN), LoadBalancerTags.valueOrUnknown("serviceId", UNKNOWN));
    }

    private static String getHost(RequestData requestData) {
        return requestData.getUrl() != null ? requestData.getUrl().getHost() : UNKNOWN;
    }

    static Iterable<Tag> buildFailedRequestTags(CompletionContext<Object, ServiceInstance, Object> completionContext) {
        RequestData requestData;
        ServiceInstance serviceInstance = completionContext.getLoadBalancerResponse().getServer();
        Tags tags = Tags.of(LoadBalancerTags.buildServiceInstanceTags(serviceInstance)).and(LoadBalancerTags.exception(completionContext.getThrowable()));
        if (completionContext.getLoadBalancerRequest().getContext() instanceof RequestDataContext && (requestData = ((RequestDataContext)completionContext.getLoadBalancerRequest().getContext()).getClientRequest()) != null) {
            return tags.and(Tags.of(LoadBalancerTags.valueOrUnknown("method", requestData.getHttpMethod()), LoadBalancerTags.valueOrUnknown("uri", LoadBalancerTags.getPath(requestData))));
        }
        return tags.and(Tags.of(LoadBalancerTags.valueOrUnknown("method", UNKNOWN), LoadBalancerTags.valueOrUnknown("uri", UNKNOWN)));
    }

    static Iterable<Tag> buildServiceInstanceTags(ServiceInstance serviceInstance) {
        return Tags.of(LoadBalancerTags.valueOrUnknown("serviceId", serviceInstance.getServiceId()), LoadBalancerTags.valueOrUnknown("serviceInstance.instanceId", serviceInstance.getInstanceId()), LoadBalancerTags.valueOrUnknown("serviceInstance.host", serviceInstance.getHost()), LoadBalancerTags.valueOrUnknown("serviceInstance.port", String.valueOf(serviceInstance.getPort())));
    }

    private static Tag valueOrUnknown(String key, String value) {
        if (value != null) {
            return Tag.of(key, value);
        }
        return Tag.of(key, UNKNOWN);
    }

    private static Tag valueOrUnknown(String key, Object value) {
        if (value != null) {
            return Tag.of(key, String.valueOf(value));
        }
        return Tag.of(key, UNKNOWN);
    }

    private static Tag exception(Throwable exception) {
        if (exception != null) {
            String simpleName = exception.getClass().getSimpleName();
            return Tag.of("exception", StringUtils.hasText(simpleName) ? simpleName : exception.getClass().getName());
        }
        return Tag.of("exception", "None");
    }

    public static String forStatus(int status) {
        if (status >= 100 && status < 200) {
            return "INFORMATIONAL";
        }
        if (status >= 200 && status < 300) {
            return "SUCCESS";
        }
        if (status >= 300 && status < 400) {
            return "REDIRECTION";
        }
        if (status >= 400 && status < 500) {
            return "CLIENT_ERROR";
        }
        if (status >= 500 && status < 600) {
            return "SERVER_ERROR";
        }
        return UNKNOWN;
    }
}

