/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.cache;

import com.stoyanr.evictor.ConcurrentMapWithTimedEviction;
import com.stoyanr.evictor.map.ConcurrentHashMapWithTimedEviction;
import com.stoyanr.evictor.scheduler.DelayedTaskEvictionScheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultLoadBalancerCache
extends AbstractValueAdaptingCache {
    private final String name;
    private final ConcurrentMapWithTimedEviction<Object, Object> cache;
    private final long evictMs;

    DefaultLoadBalancerCache(String name, ConcurrentMapWithTimedEviction<Object, Object> cache, long evictMs, boolean allowNullValues) {
        super(allowNullValues);
        Assert.notNull((Object)name, "Name must not be null");
        Assert.notNull(cache, "Cache must not be null");
        this.name = name;
        this.cache = cache;
        this.evictMs = evictMs;
    }

    public DefaultLoadBalancerCache(String name) {
        this(name, new ConcurrentHashMapWithTimedEviction<Object, Object>(256, new DelayedTaskEvictionScheduler()), 0L, true);
    }

    public DefaultLoadBalancerCache(String name, long evictMs, boolean allowNullValues) {
        this(name, new ConcurrentHashMapWithTimedEviction<Object, Object>(256, new DelayedTaskEvictionScheduler()), evictMs, allowNullValues);
    }

    public DefaultLoadBalancerCache(String name, boolean allowNullValues) {
        this(name, new ConcurrentHashMapWithTimedEviction<Object, Object>(256, new DelayedTaskEvictionScheduler()), 0L, allowNullValues);
    }

    @Override
    protected Object lookup(Object key) {
        return this.cache.get(key);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConcurrentMap<Object, Object> getNativeCache() {
        return this.cache;
    }

    @Override
    @Nullable
    public <T> T get(Object key, Callable<T> valueLoader) {
        return (T)this.fromStoreValue(this.cache.computeIfAbsent(key, k -> {
            try {
                return this.toStoreValue(valueLoader.call());
            }
            catch (Throwable ex) {
                throw new Cache.ValueRetrievalException(key, valueLoader, ex);
            }
        }));
    }

    public void put(Object key, @Nullable Object value, long evictMs) {
        this.cache.put(key, this.toStoreValue(value), evictMs);
    }

    @Override
    @Nullable
    public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value) {
        Object existing = this.cache.putIfAbsent(key, this.toStoreValue(value), this.evictMs);
        return this.toValueWrapper(existing);
    }

    @Nullable
    public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value, long evictMs) {
        Object existing = this.cache.putIfAbsent(key, this.toStoreValue(value), evictMs);
        return this.toValueWrapper(existing);
    }

    @Override
    public void put(Object key, @Nullable Object value) {
        this.cache.put(key, this.toStoreValue(value), this.evictMs);
    }

    @Override
    public void evict(Object key) {
        this.cache.remove(key);
    }

    @Override
    public boolean evictIfPresent(Object key) {
        return this.cache.remove(key) != null;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean invalidate() {
        boolean notEmpty = !this.cache.isEmpty();
        this.cache.clear();
        return notEmpty;
    }

    long getEvictMs() {
        return this.evictMs;
    }
}

