/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.http.HttpMethod;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class MethodRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String METHODS_KEY = "methods";

    public MethodRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(METHODS_KEY);
    }

    @Override
    public ShortcutConfigurable.ShortcutType shortcutType() {
        return ShortcutConfigurable.ShortcutType.GATHER_LIST;
    }

    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        return new GatewayPredicate(){

            @Override
            public boolean test(ServerWebExchange exchange2) {
                HttpMethod requestMethod = exchange2.getRequest().getMethod();
                return Arrays.stream(config.getMethods()).anyMatch(httpMethod -> httpMethod == requestMethod);
            }

            public String toString() {
                return String.format("Methods: %s", Arrays.toString(config.getMethods()));
            }
        };
    }

    @Validated
    public static class Config {
        private HttpMethod[] methods;

        public HttpMethod[] getMethods() {
            return this.methods;
        }

        public void setMethods(HttpMethod ... methods) {
            this.methods = methods;
        }
    }
}

