/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;

public class TransferEncodingNormalizationHeadersFilter
implements HttpHeadersFilter,
Ordered {
    @Override
    public int getOrder() {
        return 1000;
    }

    @Override
    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange2) {
        String transferEncoding = input.getFirst("Transfer-Encoding");
        if (transferEncoding != null && "chunked".equalsIgnoreCase(transferEncoding.trim()) && input.containsKey("Content-Length")) {
            HttpHeaders filtered = new HttpHeaders();
            filtered.addAll(input);
            filtered.remove("Content-Length");
            return filtered;
        }
        return input;
    }
}

