/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.netty.http.server.HttpServerResponse;

public class GRPCResponseHeadersFilter
implements HttpHeadersFilter,
Ordered {
    private static final String GRPC_STATUS_HEADER = "grpc-status";
    private static final String GRPC_MESSAGE_HEADER = "grpc-message";

    @Override
    public HttpHeaders filter(HttpHeaders headers, ServerWebExchange exchange2) {
        ServerHttpResponse response = exchange2.getResponse();
        HttpHeaders responseHeaders = response.getHeaders();
        if (this.isGRPC(exchange2)) {
            Object trailerHeaderValue = "grpc-status,grpc-message";
            String originalTrailerHeaderValue = responseHeaders.getFirst("Trailer");
            if (originalTrailerHeaderValue != null) {
                trailerHeaderValue = (String)trailerHeaderValue + "," + originalTrailerHeaderValue;
            }
            responseHeaders.set("Trailer", (String)trailerHeaderValue);
            while (response instanceof ServerHttpResponseDecorator) {
                response = ((ServerHttpResponseDecorator)response).getDelegate();
            }
            if (response instanceof AbstractServerHttpResponse) {
                String grpcStatus = this.getGrpcStatus(headers);
                String grpcMessage = this.getGrpcMessage(headers);
                ((HttpServerResponse)((AbstractServerHttpResponse)response).getNativeResponse()).trailerHeaders(h -> {
                    h.set(GRPC_STATUS_HEADER, (Object)grpcStatus);
                    h.set(GRPC_MESSAGE_HEADER, (Object)grpcMessage);
                });
            }
        }
        return headers;
    }

    private boolean isGRPC(ServerWebExchange exchange2) {
        String contentTypeValue = exchange2.getRequest().getHeaders().getFirst("Content-Type");
        return StringUtils.startsWithIgnoreCase(contentTypeValue, "application/grpc");
    }

    private String getGrpcStatus(HttpHeaders headers) {
        String grpcStatusValue = headers.getFirst(GRPC_STATUS_HEADER);
        return StringUtils.hasText(grpcStatusValue) ? grpcStatusValue : "0";
    }

    private String getGrpcMessage(HttpHeaders headers) {
        String grpcStatusValue = headers.getFirst(GRPC_MESSAGE_HEADER);
        return StringUtils.hasText(grpcStatusValue) ? grpcStatusValue : "";
    }

    @Override
    public boolean supports(HttpHeadersFilter.Type type) {
        return HttpHeadersFilter.Type.RESPONSE.equals((Object)type);
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

