/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractNameValueGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class AddResponseHeaderGatewayFilterFactory
extends AbstractNameValueGatewayFilterFactory {
    @Override
    public GatewayFilter apply(final AbstractNameValueGatewayFilterFactory.NameValueConfig config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
                return chain.filter(exchange2).then(Mono.fromRunnable(() -> AddResponseHeaderGatewayFilterFactory.this.addHeader(exchange2, config)));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(AddResponseHeaderGatewayFilterFactory.this).append(config.getName(), config.getValue()).toString();
            }
        };
    }

    void addHeader(ServerWebExchange exchange2, AbstractNameValueGatewayFilterFactory.NameValueConfig config) {
        String value = ServerWebExchangeUtils.expand(exchange2, config.getValue());
        HttpHeaders headers = exchange2.getResponse().getHeaders();
        if (!exchange2.getResponse().isCommitted()) {
            headers.add(config.getName(), value);
        }
    }
}

