/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.net.URI;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebClientHttpRoutingFilter
implements GlobalFilter,
Ordered {
    private final WebClient webClient;
    private final ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider;
    private volatile List<HttpHeadersFilter> headersFilters;

    public WebClientHttpRoutingFilter(WebClient webClient, ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider) {
        this.webClient = webClient;
        this.headersFiltersProvider = headersFiltersProvider;
    }

    public List<HttpHeadersFilter> getHeadersFilters() {
        if (this.headersFilters == null) {
            this.headersFilters = this.headersFiltersProvider.getIfAvailable();
        }
        return this.headersFilters;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
        URI requestUrl = (URI)exchange2.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme();
        if (ServerWebExchangeUtils.isAlreadyRouted(exchange2) || !"http".equals(scheme) && !"https".equals(scheme)) {
            return chain.filter(exchange2);
        }
        ServerWebExchangeUtils.setAlreadyRouted(exchange2);
        ServerHttpRequest request = exchange2.getRequest();
        HttpMethod method = request.getMethod();
        HttpHeaders filteredHeaders = HttpHeadersFilter.filterRequest(this.getHeadersFilters(), exchange2);
        boolean preserveHost = exchange2.getAttributeOrDefault(ServerWebExchangeUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, false);
        WebClient.RequestBodySpec bodySpec = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(method).uri(requestUrl)).headers(httpHeaders -> {
            httpHeaders.addAll(filteredHeaders);
            if (!preserveHost) {
                httpHeaders.remove("Host");
            }
        });
        WebClient.RequestHeadersSpec<WebClient.RequestBodySpec> headersSpec = this.requiresBody(method) ? bodySpec.body(BodyInserters.fromDataBuffers(request.getBody())) : bodySpec;
        return headersSpec.exchangeToMono(Mono::just).flatMap(res -> {
            ServerHttpResponse response = exchange2.getResponse();
            response.getHeaders().putAll(res.headers().asHttpHeaders());
            response.setStatusCode(res.statusCode());
            exchange2.getAttributes().put(ServerWebExchangeUtils.CLIENT_RESPONSE_ATTR, res);
            return chain.filter(exchange2);
        });
    }

    private boolean requiresBody(HttpMethod method) {
        return method.equals(HttpMethod.PUT) || method.equals(HttpMethod.POST) || method.equals(HttpMethod.PATCH);
    }
}

