/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;

public class NettyWriteResponseFilter
implements GlobalFilter,
Ordered {
    public static final int WRITE_RESPONSE_FILTER_ORDER = -1;
    private static final Log log = LogFactory.getLog(NettyWriteResponseFilter.class);
    private final List<MediaType> streamingMediaTypes;

    public NettyWriteResponseFilter(List<MediaType> streamingMediaTypes) {
        this.streamingMediaTypes = streamingMediaTypes;
    }

    @Override
    public int getOrder() {
        return -1;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
        return chain.filter(exchange2).then(Mono.defer(() -> {
            MediaType contentType;
            Flux<DataBuffer> body2;
            ServerHttpResponse response;
            block4: {
                Connection connection = (Connection)exchange2.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
                if (connection == null) {
                    return Mono.empty();
                }
                if (log.isTraceEnabled()) {
                    log.trace("NettyWriteResponseFilter start inbound: " + connection.channel().id().asShortText() + ", outbound: " + exchange2.getLogPrefix());
                }
                response = exchange2.getResponse();
                body2 = connection.inbound().receive().retain().map(byteBuf -> this.wrap((ByteBuf)byteBuf, response));
                contentType = null;
                try {
                    contentType = response.getHeaders().getContentType();
                }
                catch (Exception e) {
                    if (!log.isTraceEnabled()) break block4;
                    log.trace("invalid media type", e);
                }
            }
            return this.isStreamingMediaType(contentType) ? response.writeAndFlushWith(body2.map(Flux::just)) : response.writeWith(body2);
        })).doOnCancel(() -> this.cleanup(exchange2)).doOnError(throwable -> this.cleanup(exchange2));
    }

    protected DataBuffer wrap(ByteBuf byteBuf, ServerHttpResponse response) {
        DataBufferFactory bufferFactory = response.bufferFactory();
        if (bufferFactory instanceof NettyDataBufferFactory) {
            NettyDataBufferFactory factory = (NettyDataBufferFactory)bufferFactory;
            return factory.wrap(byteBuf);
        }
        if (bufferFactory instanceof DefaultDataBufferFactory) {
            DefaultDataBuffer buffer = ((DefaultDataBufferFactory)bufferFactory).allocateBuffer(byteBuf.readableBytes());
            buffer.write(new ByteBuffer[]{byteBuf.nioBuffer()});
            byteBuf.release();
            return buffer;
        }
        throw new IllegalArgumentException("Unkown DataBufferFactory type " + bufferFactory.getClass());
    }

    private void cleanup(ServerWebExchange exchange2) {
        Connection connection = (Connection)exchange2.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
        if (connection != null && connection.channel().isActive()) {
            connection.dispose();
        }
    }

    private boolean isStreamingMediaType(@Nullable MediaType contentType) {
        if (contentType != null) {
            for (int i2 = 0; i2 < this.streamingMediaTypes.size(); ++i2) {
                if (!this.streamingMediaTypes.get(i2).isCompatibleWith(contentType)) continue;
                return true;
            }
        }
        return false;
    }
}

