/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.discovery;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.core.style.ToStringCreator;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class DiscoveryClientRouteDefinitionLocator
implements RouteDefinitionLocator {
    private static final Log log = LogFactory.getLog(DiscoveryClientRouteDefinitionLocator.class);
    private final DiscoveryLocatorProperties properties;
    private final String routeIdPrefix;
    private final SimpleEvaluationContext evalCtxt;
    private Flux<List<ServiceInstance>> serviceInstances;

    public DiscoveryClientRouteDefinitionLocator(ReactiveDiscoveryClient discoveryClient, DiscoveryLocatorProperties properties) {
        this(discoveryClient.getClass().getSimpleName(), properties);
        this.serviceInstances = discoveryClient.getServices().flatMap(service -> discoveryClient.getInstances((String)service).collectList());
    }

    private DiscoveryClientRouteDefinitionLocator(String discoveryClientName, DiscoveryLocatorProperties properties) {
        this.properties = properties;
        this.routeIdPrefix = StringUtils.hasText(properties.getRouteIdPrefix()) ? properties.getRouteIdPrefix() : discoveryClientName + "_";
        this.evalCtxt = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
    }

    @Override
    public Flux<RouteDefinition> getRouteDefinitions() {
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression includeExpr = parser.parseExpression(this.properties.getIncludeExpression());
        Expression urlExpr = parser.parseExpression(this.properties.getUrlExpression());
        Predicate<ServiceInstance> includePredicate = this.properties.getIncludeExpression() == null || "true".equalsIgnoreCase(this.properties.getIncludeExpression()) ? instance -> true : instance -> {
            Boolean include = includeExpr.getValue(this.evalCtxt, instance, Boolean.class);
            if (include == null) {
                return false;
            }
            return include;
        };
        return this.serviceInstances.filter(instances -> !instances.isEmpty()).flatMap(Flux::fromIterable).filter(includePredicate).collectMap(ServiceInstance::getServiceId).flatMapMany(map -> Flux.fromIterable(map.values())).map(instance -> {
            String value;
            RouteDefinition routeDefinition = this.buildRouteDefinition(urlExpr, (ServiceInstance)instance);
            DelegatingServiceInstance instanceForEval = new DelegatingServiceInstance((ServiceInstance)instance, this.properties);
            for (PredicateDefinition predicateDefinition : this.properties.getPredicates()) {
                PredicateDefinition predicate = new PredicateDefinition();
                predicate.setName(predicateDefinition.getName());
                for (Map.Entry<String, String> entry : predicateDefinition.getArgs().entrySet()) {
                    value = this.getValueFromExpr(this.evalCtxt, parser, instanceForEval, entry);
                    predicate.addArg(entry.getKey(), value);
                }
                routeDefinition.getPredicates().add(predicate);
            }
            for (FilterDefinition filterDefinition : this.properties.getFilters()) {
                FilterDefinition filter2 = new FilterDefinition();
                filter2.setName(filterDefinition.getName());
                for (Map.Entry<String, String> entry : filterDefinition.getArgs().entrySet()) {
                    value = this.getValueFromExpr(this.evalCtxt, parser, instanceForEval, entry);
                    filter2.addArg(entry.getKey(), value);
                }
                routeDefinition.getFilters().add(filter2);
            }
            return routeDefinition;
        });
    }

    protected RouteDefinition buildRouteDefinition(Expression urlExpr, ServiceInstance serviceInstance) {
        String serviceId = serviceInstance.getServiceId();
        RouteDefinition routeDefinition = new RouteDefinition();
        routeDefinition.setId(this.routeIdPrefix + serviceId);
        String uri = urlExpr.getValue(this.evalCtxt, serviceInstance, String.class);
        routeDefinition.setUri(URI.create(uri));
        routeDefinition.setMetadata(new LinkedHashMap<String, Object>(serviceInstance.getMetadata()));
        return routeDefinition;
    }

    String getValueFromExpr(SimpleEvaluationContext evalCtxt, SpelExpressionParser parser, ServiceInstance instance, Map.Entry<String, String> entry) {
        try {
            Expression valueExpr = parser.parseExpression(entry.getValue());
            return valueExpr.getValue(evalCtxt, instance, String.class);
        }
        catch (EvaluationException | ParseException e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to parse " + entry.getValue(), e);
            }
            throw e;
        }
    }

    private static class DelegatingServiceInstance
    implements ServiceInstance {
        final ServiceInstance delegate;
        private final DiscoveryLocatorProperties properties;

        private DelegatingServiceInstance(ServiceInstance delegate, DiscoveryLocatorProperties properties) {
            this.delegate = delegate;
            this.properties = properties;
        }

        @Override
        public String getServiceId() {
            if (this.properties.isLowerCaseServiceId()) {
                return this.delegate.getServiceId().toLowerCase();
            }
            return this.delegate.getServiceId();
        }

        @Override
        public String getHost() {
            return this.delegate.getHost();
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public boolean isSecure() {
            return this.delegate.isSecure();
        }

        @Override
        public URI getUri() {
            return this.delegate.getUri();
        }

        @Override
        public Map<String, String> getMetadata() {
            return this.delegate.getMetadata();
        }

        @Override
        public String getScheme() {
            return this.delegate.getScheme();
        }

        public String toString() {
            return new ToStringCreator(this).append("delegate", this.delegate).append("properties", this.properties).toString();
        }
    }
}

