/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.encrypt;

import org.springframework.cloud.context.encrypt.KeyFormatException;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;

public class EncryptorFactory {
    private String salt = "deadbeef";

    public EncryptorFactory() {
    }

    public EncryptorFactory(String salt) {
        this.salt = salt;
    }

    public TextEncryptor create(String data) {
        TextEncryptor encryptor;
        if (data.contains("RSA PRIVATE KEY")) {
            encryptor = new RsaSecretEncryptor(data.replaceAll("\\n *", ""));
        } else {
            if (data.startsWith("ssh-rsa") || data.contains("RSA PUBLIC KEY")) {
                throw new KeyFormatException();
            }
            encryptor = Encryptors.text(data, this.salt);
        }
        return encryptor;
    }
}

