/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import org.springframework.cloud.configuration.CompatibilityVerifier;
import org.springframework.cloud.configuration.VerificationResult;
import org.springframework.util.ClassUtils;

class SleuthPresentVerifier
implements CompatibilityVerifier {
    private static final String TRACER_CLASS = "org.springframework.cloud.sleuth.Tracer";
    private static final String ERROR_DESCRIPTION = "Spring Cloud Sleuth is not compatible with this Spring Cloud release train";
    private static final String ACTION = "Migrate from Spring Cloud Sleuth to Micrometer Tracing .\nYou can check the Sleuth 3.1 Migration Guide over here [https://github.com/micrometer-metrics/tracing/wiki/Spring-Cloud-Sleuth-3.1-Migration-Guide]. \nIf you want to disable this check, just set the property [spring.cloud.compatibility-verifier.enabled=false]";

    SleuthPresentVerifier() {
    }

    @Override
    public VerificationResult verify() {
        boolean present = this.sleuthPresent();
        if (!present) {
            return VerificationResult.compatible();
        }
        return VerificationResult.notCompatible(ERROR_DESCRIPTION, ACTION);
    }

    boolean sleuthPresent() {
        return ClassUtils.isPresent(TRACER_CLASS, null);
    }
}

